# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import date
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, validator
from synctera_client.models.hold_data import HoldData

class OutgoingAch(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    account_name: Optional[StrictStr] = Field(None, description="Receiving account name")
    account_no: StrictStr = Field(..., description="Receiving account number")
    amount: StrictInt = Field(..., description="Transaction amount in cents")
    bank_id: StrictInt = ...
    effective_date: date = Field(..., description="Effective date of the transaction")
    external_id: StrictStr = Field(..., description="Transaction ID in the ledger")
    hold: Optional[HoldData] = None
    id: StrictStr = ...
    is_same_day: StrictBool = Field(..., description="Was initiated as same-day ACH transaction")
    memo: StrictStr = ...
    partner_id: StrictInt = ...
    reference_info: Optional[StrictStr] = Field(None, description="Transaction reference info")
    source_account_name: Optional[StrictStr] = Field(None, description="Originating account name")
    source_account_no: StrictStr = Field(..., description="Originating account number")
    status: StrictStr = ...
    trace_no: StrictStr = Field(..., description="Trace number of the transaction")
    __properties = ["account_name", "account_no", "amount", "bank_id", "effective_date", "external_id", "hold", "id", "is_same_day", "memo", "partner_id", "reference_info", "source_account_name", "source_account_no", "status", "trace_no"]

    @validator('status')
    def status_validate_enum(cls, v):
        if v not in ('INIT', 'PENDING', 'CANCELED', 'COMPLETE', 'DECLINED'):
            raise ValueError("must validate the enum values ('INIT', 'PENDING', 'CANCELED', 'COMPLETE', 'DECLINED')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OutgoingAch:
        """Create an instance of OutgoingAch from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of hold
        if self.hold:
            _dict['hold'] = self.hold.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OutgoingAch:
        """Create an instance of OutgoingAch from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OutgoingAch.parse_obj(obj)

        _obj = OutgoingAch.parse_obj({
            "account_name": obj.get("account_name"),
            "account_no": obj.get("account_no"),
            "amount": obj.get("amount"),
            "bank_id": obj.get("bank_id"),
            "effective_date": obj.get("effective_date"),
            "external_id": obj.get("external_id"),
            "hold": HoldData.from_dict(obj.get("hold")) if obj.get("hold") is not None else None,
            "id": obj.get("id"),
            "is_same_day": obj.get("is_same_day"),
            "memo": obj.get("memo"),
            "partner_id": obj.get("partner_id"),
            "reference_info": obj.get("reference_info"),
            "source_account_name": obj.get("source_account_name"),
            "source_account_no": obj.get("source_account_no"),
            "status": obj.get("status"),
            "trace_no": obj.get("trace_no")
        })
        return _obj

