# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, StrictStr, constr, validator

class OriginalCreditSenderData(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    funding_source: StrictStr = ...
    sender_account_number: Optional[StrictStr] = None
    sender_account_type: Optional[StrictStr] = None
    sender_address: Optional[StrictStr] = None
    sender_city: Optional[StrictStr] = None
    sender_country: Optional[StrictStr] = None
    sender_name: Optional[StrictStr] = None
    sender_reference_number: Optional[StrictStr] = None
    sender_state: Optional[StrictStr] = None
    transaction_purpose: Optional[StrictStr] = None
    unique_transaction_reference_number: Optional[constr(strict=True, max_length=17, min_length=1)] = None
    __properties = ["funding_source", "sender_account_number", "sender_account_type", "sender_address", "sender_city", "sender_country", "sender_name", "sender_reference_number", "sender_state", "transaction_purpose", "unique_transaction_reference_number"]

    @validator('funding_source')
    def funding_source_validate_enum(cls, v):
        if v not in ('credit', 'debit', 'prepaid', 'deposit_account', 'cash', 'mobile_money_payment', 'non_visa_credit'):
            raise ValueError("must validate the enum values ('credit', 'debit', 'prepaid', 'deposit_account', 'cash', 'mobile_money_payment', 'non_visa_credit')")
        return v

    @validator('sender_account_type')
    def sender_account_type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('other', 'rtn_bank_account', 'iban', 'card_account', 'email', 'phone_number', 'bank_account_number_and_identification_code', 'wallet_id', 'social_network_id'):
            raise ValueError("must validate the enum values ('other', 'rtn_bank_account', 'iban', 'card_account', 'email', 'phone_number', 'bank_account_number_and_identification_code', 'wallet_id', 'social_network_id')")
        return v

    @validator('transaction_purpose')
    def transaction_purpose_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('family_support', 'labor_transfers', 'travel', 'education', 'medical_treatment', 'emergency_need', 'savings', 'gifts', 'other', 'salary', 'lending', 'crypto_currency'):
            raise ValueError("must validate the enum values ('family_support', 'labor_transfers', 'travel', 'education', 'medical_treatment', 'emergency_need', 'savings', 'gifts', 'other', 'salary', 'lending', 'crypto_currency')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OriginalCreditSenderData:
        """Create an instance of OriginalCreditSenderData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OriginalCreditSenderData:
        """Create an instance of OriginalCreditSenderData from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OriginalCreditSenderData.parse_obj(obj)

        _obj = OriginalCreditSenderData.parse_obj({
            "funding_source": obj.get("funding_source"),
            "sender_account_number": obj.get("sender_account_number"),
            "sender_account_type": obj.get("sender_account_type"),
            "sender_address": obj.get("sender_address"),
            "sender_city": obj.get("sender_city"),
            "sender_country": obj.get("sender_country"),
            "sender_name": obj.get("sender_name"),
            "sender_reference_number": obj.get("sender_reference_number"),
            "sender_state": obj.get("sender_state"),
            "transaction_purpose": obj.get("transaction_purpose"),
            "unique_transaction_reference_number": obj.get("unique_transaction_reference_number")
        })
        return _obj

