# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictStr
from synctera_client.models.related_resource_type1 import RelatedResourceType1

class NoteResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    author: StrictStr = Field(..., description="The note's author.")
    content: StrictStr = Field(..., description="The note's text content.")
    creation_time: datetime = Field(..., description="The date and time the note was created.")
    id: StrictStr = Field(..., description="note ID")
    last_updated_time: datetime = Field(..., description="The date and time the note was last updated.")
    metadata: Optional[Dict[str, Any]] = Field(None, description="Optional field to store additional information about the resource. Intended to be used by the integrator to store non-sensitive data. ")
    related_resource_id: StrictStr = Field(..., description="The id of the resource that is associated with the note. This is typically a UUID. For TENANT it is a string tenant ID. ")
    related_resource_type: RelatedResourceType1 = ...
    tenant: StrictStr = Field(..., description="The tenant containing the resource. Tenancy is represented as bank_id_partner_id. This attribute is included on all responses. For requests, it is optional for clients with access to a single tenant. ")
    __properties = ["author", "content", "creation_time", "id", "last_updated_time", "metadata", "related_resource_id", "related_resource_type", "tenant"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> NoteResponse:
        """Create an instance of NoteResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "creation_time",
                            "id",
                            "last_updated_time",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> NoteResponse:
        """Create an instance of NoteResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return NoteResponse.parse_obj(obj)

        _obj = NoteResponse.parse_obj({
            "author": obj.get("author"),
            "content": obj.get("content"),
            "creation_time": obj.get("creation_time"),
            "id": obj.get("id"),
            "last_updated_time": obj.get("last_updated_time"),
            "metadata": obj.get("metadata"),
            "related_resource_id": obj.get("related_resource_id"),
            "related_resource_type": obj.get("related_resource_type"),
            "tenant": obj.get("tenant")
        })
        return _obj

