# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictStr, validator

class InternalTransferResponseAllOf(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    id: StrictStr = Field(..., description="The transaction id associated with the transfer")
    status: StrictStr = Field(..., description="The status of the internal transfer auth. A value of `PENDING` indicates that the funds have been reserved and the transaction is ready to be either completed or canceled. A value of `COMPLETE` indicates the funds have been successfully moved and no more action can be performed. A value of `CANCELED` or `EXPIRED` means that the transaction has rolled back and the funds have been returned to the originating account, either by explicitly canceling via the API, or due to the expiry time having passed.")
    __properties = ["id", "status"]

    @validator('status')
    def status_validate_enum(cls, v):
        if v not in ('PENDING', 'COMPLETE', 'CANCELED', 'EXPIRED'):
            raise ValueError("must validate the enum values ('PENDING', 'COMPLETE', 'CANCELED', 'EXPIRED')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InternalTransferResponseAllOf:
        """Create an instance of InternalTransferResponseAllOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InternalTransferResponseAllOf:
        """Create an instance of InternalTransferResponseAllOf from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return InternalTransferResponseAllOf.parse_obj(obj)

        _obj = InternalTransferResponseAllOf.parse_obj({
            "id": obj.get("id"),
            "status": obj.get("status")
        })
        return _obj

