# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictStr, conint, validator

class InternalTransferResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    amount: conint(strict=True, ge=1) = Field(..., description="The amount (in cents) to transfer from originating account to receiving account.")
    capture_mode: Optional[StrictStr] = Field('IMMEDIATE', description="Controls when the transfer will take effect. A value of `IMMEDIATE` (the default) means that the transfer will be completed immediately. A value of `MANUAL` means that the transaction will remain in a \"pending\" state until explicitly completed or cancelled (or the auth expires).")
    currency: StrictStr = Field(..., description="ISO 4217 alphabetic currency code of the transfer amount")
    expires_at: Optional[datetime] = Field(None, description="When `capture_mode` is `MANUAL`, this field describes when the pending transaction should expire.")
    final_customer_id: Optional[StrictStr] = Field(None, description="The customer id of the international customer that receives the final remittance transfer (required for remittance payments).")
    memo: Optional[StrictStr] = Field(None, description="A short note to the recipient")
    metadata: Optional[Dict[str, Any]] = Field(None, description="Arbitrary key-value metadata to associate with the transaction")
    originating_account_alias: Optional[StrictStr] = Field(None, description="An alias representing a GL account to debit. This is alternative to specifying by account id")
    originating_account_customer_id: Optional[StrictStr] = Field(None, description="The customer id of the owner of the originating account.")
    originating_account_id: Optional[StrictStr] = Field(None, description="The UUID of the account being debited")
    receiving_account_alias: Optional[StrictStr] = Field(None, description="An alias representing a GL account to credit. This is an alternative to specifying by account id")
    receiving_account_customer_id: Optional[StrictStr] = Field(None, description="The customer id of the owner of the receiving account.")
    receiving_account_id: Optional[StrictStr] = Field(None, description="The UUID of the account being credited")
    type: StrictStr = Field(..., description="The desired transaction type to use for this transfer")
    id: StrictStr = Field(..., description="The transaction id associated with the transfer")
    status: StrictStr = Field(..., description="The status of the internal transfer auth. A value of `PENDING` indicates that the funds have been reserved and the transaction is ready to be either completed or canceled. A value of `COMPLETE` indicates the funds have been successfully moved and no more action can be performed. A value of `CANCELED` or `EXPIRED` means that the transaction has rolled back and the funds have been returned to the originating account, either by explicitly canceling via the API, or due to the expiry time having passed.")
    __properties = ["amount", "capture_mode", "currency", "expires_at", "final_customer_id", "memo", "metadata", "originating_account_alias", "originating_account_customer_id", "originating_account_id", "receiving_account_alias", "receiving_account_customer_id", "receiving_account_id", "type", "id", "status"]

    @validator('capture_mode')
    def capture_mode_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('IMMEDIATE', 'MANUAL'):
            raise ValueError("must validate the enum values ('IMMEDIATE', 'MANUAL')")
        return v

    @validator('type')
    def type_validate_enum(cls, v):
        if v not in ('ACCOUNT_TO_ACCOUNT', 'ACH_CREDIT_SWEEP', 'ACH_DEBIT_SWEEP', 'ACH_FLOAT_TRANSFER', 'ACH_SWEEP', 'CASHBACK', 'FEE', 'INCOMING_WIRE', 'INTEREST_PAYOUT', 'LOAN_DISBURSEMENT', 'LOAN_FUNDING', 'MANUAL_ADJUSTMENT', 'MANUAL_ADJUSTMENT_REVERSAL', 'MANUAL_CARD_SWEEP', 'OUTGOING_INTERNATIONAL_REMITTANCE', 'OUTGOING_INTERNATIONAL_REMITTANCE_REVERSAL', 'PROMOTIONAL_CREDIT', 'SIGN_UP_BONUS', 'SUBSCRIPTION_FEE', 'TRANSFER_FEE', 'TRANSFER_FEE_REVERSAL', 'WIRE_SETTLEMENT_CREDIT', 'WIRE_SETTLEMENT_DEBIT'):
            raise ValueError("must validate the enum values ('ACCOUNT_TO_ACCOUNT', 'ACH_CREDIT_SWEEP', 'ACH_DEBIT_SWEEP', 'ACH_FLOAT_TRANSFER', 'ACH_SWEEP', 'CASHBACK', 'FEE', 'INCOMING_WIRE', 'INTEREST_PAYOUT', 'LOAN_DISBURSEMENT', 'LOAN_FUNDING', 'MANUAL_ADJUSTMENT', 'MANUAL_ADJUSTMENT_REVERSAL', 'MANUAL_CARD_SWEEP', 'OUTGOING_INTERNATIONAL_REMITTANCE', 'OUTGOING_INTERNATIONAL_REMITTANCE_REVERSAL', 'PROMOTIONAL_CREDIT', 'SIGN_UP_BONUS', 'SUBSCRIPTION_FEE', 'TRANSFER_FEE', 'TRANSFER_FEE_REVERSAL', 'WIRE_SETTLEMENT_CREDIT', 'WIRE_SETTLEMENT_DEBIT')")
        return v

    @validator('status')
    def status_validate_enum(cls, v):
        if v not in ('PENDING', 'COMPLETE', 'CANCELED', 'EXPIRED'):
            raise ValueError("must validate the enum values ('PENDING', 'COMPLETE', 'CANCELED', 'EXPIRED')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InternalTransferResponse:
        """Create an instance of InternalTransferResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InternalTransferResponse:
        """Create an instance of InternalTransferResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return InternalTransferResponse.parse_obj(obj)

        _obj = InternalTransferResponse.parse_obj({
            "amount": obj.get("amount"),
            "capture_mode": obj.get("capture_mode") if obj.get("capture_mode") is not None else 'IMMEDIATE',
            "currency": obj.get("currency"),
            "expires_at": obj.get("expires_at"),
            "final_customer_id": obj.get("final_customer_id"),
            "memo": obj.get("memo"),
            "metadata": obj.get("metadata"),
            "originating_account_alias": obj.get("originating_account_alias"),
            "originating_account_customer_id": obj.get("originating_account_customer_id"),
            "originating_account_id": obj.get("originating_account_id"),
            "receiving_account_alias": obj.get("receiving_account_alias"),
            "receiving_account_customer_id": obj.get("receiving_account_customer_id"),
            "receiving_account_id": obj.get("receiving_account_id"),
            "type": obj.get("type"),
            "id": obj.get("id"),
            "status": obj.get("status")
        })
        return _obj

