# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, constr, validator
from synctera_client.models.balance import Balance
from synctera_client.models.internal_account_purpose import InternalAccountPurpose
from synctera_client.models.internal_account_type import InternalAccountType

class InternalAccount(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    account_number: Optional[constr(strict=True, max_length=17, min_length=14)] = Field(None, description="Generated internal account number")
    account_type: Optional[InternalAccountType] = None
    balances: Optional[List[Balance]] = Field(None, description="A list of balances for internal account based on different type")
    bank_routing: Optional[constr(strict=True, max_length=9)] = Field(None, description="Bank routing number")
    creation_time: Optional[datetime] = Field(None, description="The date and time the resource was created.")
    currency: constr(strict=True) = Field(..., description="Account currency or account settlement currency. ISO 4217 alphabetic currency code.")
    description: Optional[StrictStr] = Field(None, description="A user provided description for the current account")
    gl_type: Optional[StrictStr] = Field(None, description="What type of general ledger account this internal account represents. ")
    id: Optional[StrictStr] = Field(None, description="Generated ID for internal account")
    is_system_acc: Optional[StrictBool] = Field(False, description="Is a system-controlled internal account. When this field is true, this internal account will be reserved exclusively for internal use by the Synctera platform and any internal transfers to or from this internal account will be declined.")
    last_updated_time: Optional[datetime] = Field(None, description="The date and time the resource was last updated.")
    purpose: Optional[InternalAccountPurpose] = None
    status: StrictStr = ...
    __properties = ["account_number", "account_type", "balances", "bank_routing", "creation_time", "currency", "description", "gl_type", "id", "is_system_acc", "last_updated_time", "purpose", "status"]

    @validator('currency')
    def currency_validate_regular_expression(cls, v):
        if not re.match(r"^[A-Z]{3}$", v):
            raise ValueError(r"must validate the regular expression /^[A-Z]{3}$/")
        return v

    @validator('gl_type')
    def gl_type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('ASSET', 'LIABILITY', 'EXPENSE', 'REVENUE'):
            raise ValueError("must validate the enum values ('ASSET', 'LIABILITY', 'EXPENSE', 'REVENUE')")
        return v

    @validator('status')
    def status_validate_enum(cls, v):
        if v not in ('ACTIVE'):
            raise ValueError("must validate the enum values ('ACTIVE')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InternalAccount:
        """Create an instance of InternalAccount from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "account_number",
                            "balances",
                            "bank_routing",
                            "creation_time",
                            "id",
                            "last_updated_time",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in balances (list)
        _items = []
        if self.balances:
            for _item in self.balances:
                if _item:
                    _items.append(_item.to_dict())
            _dict['balances'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InternalAccount:
        """Create an instance of InternalAccount from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return InternalAccount.parse_obj(obj)

        _obj = InternalAccount.parse_obj({
            "account_number": obj.get("account_number"),
            "account_type": obj.get("account_type"),
            "balances": [Balance.from_dict(_item) for _item in obj.get("balances")] if obj.get("balances") is not None else None,
            "bank_routing": obj.get("bank_routing"),
            "creation_time": obj.get("creation_time"),
            "currency": obj.get("currency"),
            "description": obj.get("description"),
            "gl_type": obj.get("gl_type"),
            "id": obj.get("id"),
            "is_system_acc": obj.get("is_system_acc") if obj.get("is_system_acc") is not None else False,
            "last_updated_time": obj.get("last_updated_time"),
            "purpose": obj.get("purpose"),
            "status": obj.get("status")
        })
        return _obj

