# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, constr

class GatewayResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    active: StrictBool = Field(..., description="Current status of the Authorization gateway")
    card_products: List[StrictStr] = Field(..., description="List of Card Product unique identifiers that will utilize the Gateway")
    creation_time: datetime = Field(..., description="The timestamp representing when the gateway config request was made")
    custom_headers: Optional[Dict[str, StrictStr]] = Field(None, description="Custom Headers of the Authorization gateway")
    id: StrictStr = Field(..., description="Gateway ID")
    last_modified_time: datetime = Field(..., description="The timestamp representing when the gateway config was last modified at")
    url: constr(strict=True, max_length=1000) = Field(..., description="URL of the Authorization gateway")
    __properties = ["active", "card_products", "creation_time", "custom_headers", "id", "last_modified_time", "url"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GatewayResponse:
        """Create an instance of GatewayResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "creation_time",
                            "last_modified_time",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GatewayResponse:
        """Create an instance of GatewayResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return GatewayResponse.parse_obj(obj)

        _obj = GatewayResponse.parse_obj({
            "active": obj.get("active"),
            "card_products": obj.get("card_products"),
            "creation_time": obj.get("creation_time"),
            "custom_headers": obj.get("custom_headers"),
            "id": obj.get("id"),
            "last_modified_time": obj.get("last_modified_time"),
            "url": obj.get("url")
        })
        return _obj

