# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, constr, validator

class ExternalAccountLinkToken(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    business_id: Optional[StrictStr] = Field(None, description="The identifier for the business customer associated with this external account. Exactly one of `business_id` or `customer_id` must be specified. ")
    client_name: StrictStr = Field(..., description="The name of your application, as it should be displayed in Link. Maximum length of 30 characters.")
    country_codes: List[StrictStr] = Field(..., description="Country codes in the ISO-3166-1 alpha-2 country code standard.")
    customer_id: Optional[StrictStr] = Field(None, description="The identifier for the personal customer associated with this external account. Exactly one of `customer_id` or `business_id` must be specified. ")
    expiration: Optional[datetime] = Field(None, description="The expiration date for the link_token. Expires in 4 hours.")
    language: StrictStr = Field(..., description="The language that corresponds to the link token. For Plaid, see their [documentation](https://plaid.com/docs/api/tokens/#link-token-create-request-language) for a list of allowed values. ")
    link_customization_name: Optional[StrictStr] = Field(None, description="The name of the Link customization from the Plaid Dashboard to be applied to Link. If not specified, the default customization will be used. When using a Link customization, the language in the customization must match the language selected via the language parameter, and the countries in the customization should match the country codes selected via country_codes. ")
    link_token: Optional[StrictStr] = Field(None, description="A link_token, which can be supplied to Link in order to initialize it and receive a public_token, which can be exchanged for an access_token. ")
    redirect_uri: Optional[StrictStr] = Field(None, description="A URI indicating the destination where a user should be forwarded after completing the Link flow; used to support OAuth authentication flows when launching Link in the browser or via a webview. ")
    request_id: Optional[StrictStr] = Field(None, description="A unique identifier for the request, which can be used for troubleshooting.")
    sdk_type: Optional[StrictStr] = Field('WEB', description="Describes the environment of the client code running a vendor-supplied SDK")
    type: StrictStr = Field(..., description="The type of the link token. DEPOSITORY for checking and savings accounts, CREDIT for credit card type accounts, INVESTMENT for investment accounts, and MICRO_DEPOSIT for depository accounts with support for micro-deposits verification.")
    vendor_access_token: Optional[StrictStr] = Field(None, description="The access token associated with the Item data is being requested for.")
    vendor_institution_id: Optional[constr(strict=True, min_length=1)] = Field(None, description="The ID of the institution the access token is requested for. If present the link token will be created in an update mode. ")
    verify_owner: Optional[StrictBool] = Field(False, description="If true, Synctera will attempt to verify that the external account owner is the same as the customer by comparing external account data to customer data. At least 2 of the following fields must match: name, phone number, email, address. Verification is disabled by default. ")
    __properties = ["business_id", "client_name", "country_codes", "customer_id", "expiration", "language", "link_customization_name", "link_token", "redirect_uri", "request_id", "sdk_type", "type", "vendor_access_token", "vendor_institution_id", "verify_owner"]

    @validator('country_codes')
    def country_codes_validate_enum(cls, v):
        if v not in ('US'):
            raise ValueError("must validate the enum values ('US')")
        return v

    @validator('language')
    def language_validate_enum(cls, v):
        if v not in ('EN', 'FR', 'ES', 'NL', 'DE'):
            raise ValueError("must validate the enum values ('EN', 'FR', 'ES', 'NL', 'DE')")
        return v

    @validator('sdk_type')
    def sdk_type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('WEB', 'IOS', 'ANDROID'):
            raise ValueError("must validate the enum values ('WEB', 'IOS', 'ANDROID')")
        return v

    @validator('type')
    def type_validate_enum(cls, v):
        if v not in ('DEPOSITORY', 'CREDIT', 'INVESTMENT', 'MICRO_DEPOSIT'):
            raise ValueError("must validate the enum values ('DEPOSITORY', 'CREDIT', 'INVESTMENT', 'MICRO_DEPOSIT')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExternalAccountLinkToken:
        """Create an instance of ExternalAccountLinkToken from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "expiration",
                            "link_token",
                            "request_id",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExternalAccountLinkToken:
        """Create an instance of ExternalAccountLinkToken from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ExternalAccountLinkToken.parse_obj(obj)

        _obj = ExternalAccountLinkToken.parse_obj({
            "business_id": obj.get("business_id"),
            "client_name": obj.get("client_name"),
            "country_codes": obj.get("country_codes"),
            "customer_id": obj.get("customer_id"),
            "expiration": obj.get("expiration"),
            "language": obj.get("language"),
            "link_customization_name": obj.get("link_customization_name"),
            "link_token": obj.get("link_token"),
            "redirect_uri": obj.get("redirect_uri"),
            "request_id": obj.get("request_id"),
            "sdk_type": obj.get("sdk_type") if obj.get("sdk_type") is not None else 'WEB',
            "type": obj.get("type"),
            "vendor_access_token": obj.get("vendor_access_token"),
            "vendor_institution_id": obj.get("vendor_institution_id"),
            "verify_owner": obj.get("verify_owner") if obj.get("verify_owner") is not None else False
        })
        return _obj

