# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, constr, validator
from synctera_client.models.event_type_explicit import EventTypeExplicit
from synctera_client.models.response_history_item import ResponseHistoryItem

class EventTrigger(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    event_resource: Optional[StrictStr] = Field(None, description="Json string of object associated with the event. For example, if your event is ACCOUNT.CREATED, You can refer to Acccount to parse the account event to obtain the ID, status etc. ")
    event_resource_changed_fields: Optional[StrictStr] = Field(None, description="Json string of object associated with the event related to a resource change. This only contains those fields that have value changed on the event, and the field values are prior to the resource change event. ")
    event_time: Optional[datetime] = Field(None, description="Timestamp of the current event raised")
    id: Optional[StrictStr] = Field(None, description="Unique event ID of the webhook request. Use event endpoints to get more event summary data")
    metadata: Optional[constr(strict=True, max_length=1024)] = Field(None, description="Metadata that stored in the webhook subscription")
    response_history: Optional[List[ResponseHistoryItem]] = Field(None, description="Response history of the webhook request")
    status: Optional[StrictStr] = Field(None, description="Current event status. Failing event will keep retry until it is purged.")
    type: Optional[EventTypeExplicit] = None
    url: Optional[constr(strict=True, max_length=1024)] = Field(None, description="URL that the current event will be sent to")
    webhook_id: Optional[StrictStr] = Field(None, description="Webhook the current event belongs to")
    __properties = ["event_resource", "event_resource_changed_fields", "event_time", "id", "metadata", "response_history", "status", "type", "url", "webhook_id"]

    @validator('status')
    def status_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('RUNNING', 'SUCCESS', 'RETRYING', 'FAILED'):
            raise ValueError("must validate the enum values ('RUNNING', 'SUCCESS', 'RETRYING', 'FAILED')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EventTrigger:
        """Create an instance of EventTrigger from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "id",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in response_history (list)
        _items = []
        if self.response_history:
            for _item in self.response_history:
                if _item:
                    _items.append(_item.to_dict())
            _dict['response_history'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EventTrigger:
        """Create an instance of EventTrigger from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return EventTrigger.parse_obj(obj)

        _obj = EventTrigger.parse_obj({
            "event_resource": obj.get("event_resource"),
            "event_resource_changed_fields": obj.get("event_resource_changed_fields"),
            "event_time": obj.get("event_time"),
            "id": obj.get("id"),
            "metadata": obj.get("metadata"),
            "response_history": [ResponseHistoryItem.from_dict(_item) for _item in obj.get("response_history")] if obj.get("response_history") is not None else None,
            "status": obj.get("status"),
            "type": obj.get("type"),
            "url": obj.get("url"),
            "webhook_id": obj.get("webhook_id")
        })
        return _obj

