# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, confloat

class Employment(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    employer_name: StrictStr = Field(..., description="Name of customer's employer.")
    employment_from: Optional[datetime] = Field(None, description="First day of employment.")
    employment_hours: Optional[confloat(strict=True, le=80, ge=0)] = Field(None, description="Number of hours spent per week working for specified employment.")
    employment_income: Optional[StrictInt] = Field(None, description="Annual income in cents.")
    employment_income_currency: Optional[StrictStr] = Field(None, description="The 3-letter alphabetic ISO 4217 code for the currency in which the employee was paid. ")
    employment_info: Optional[Dict[str, Any]] = Field(None, description="A collection of arbitrary key-value pairs providing additional information about this employment relationship. ")
    employment_occupation: Optional[StrictStr] = Field(None, description="Customer's work title, profession, or field.")
    employment_to: Optional[datetime] = Field(None, description="Last day of employment.")
    id: Optional[StrictStr] = Field(None, description="Unique ID for this employment relationship.")
    __properties = ["employer_name", "employment_from", "employment_hours", "employment_income", "employment_income_currency", "employment_info", "employment_occupation", "employment_to", "id"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Employment:
        """Create an instance of Employment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "id",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Employment:
        """Create an instance of Employment from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Employment.parse_obj(obj)

        _obj = Employment.parse_obj({
            "employer_name": obj.get("employer_name"),
            "employment_from": obj.get("employment_from"),
            "employment_hours": obj.get("employment_hours"),
            "employment_income": obj.get("employment_income"),
            "employment_income_currency": obj.get("employment_income_currency"),
            "employment_info": obj.get("employment_info"),
            "employment_occupation": obj.get("employment_occupation"),
            "employment_to": obj.get("employment_to"),
            "id": obj.get("id")
        })
        return _obj

