# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, conint, validator
from synctera_client.models.vendor_info1 import VendorInfo1

class Deposit(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    account_id: StrictStr = Field(..., description="The ID of the account")
    back_image_id: StrictStr = Field(..., description="ID of the uploaded image of the back of the check")
    business_id: Optional[StrictStr] = Field(None, description="Unique ID for the business. Exactly one of `business_id` or `person_id` must be set. ")
    check_amount: conint(strict=True, ge=1) = Field(..., description="Amount on check in ISO 4217 minor currency units")
    creation_time: Optional[datetime] = None
    date_captured: datetime = Field(..., description="Date the deposit was captured, in RFC 3339 format")
    date_processed: datetime = Field(..., description="Date the deposit was processed, in RFC 3339 format")
    deposit_amount: StrictInt = Field(..., description="Amount deposited in ISO 4217 minor currency units")
    deposit_currency: StrictStr = Field(..., description="ISO 4217 currency code for the deposit amount")
    front_image_id: StrictStr = Field(..., description="ID of the uploaded image of the front of the check")
    id: StrictStr = Field(..., description="Remote Check Deposit ID")
    last_updated_time: Optional[datetime] = None
    metadata: Optional[Dict[str, Any]] = Field(None, description="Optional field to store additional information about the resource. Intended to be used by the integrator to store non-sensitive data. ")
    ocr_account_number: Optional[StrictStr] = Field(None, description="Account number of the issuer of the check, included if OCR is successful")
    ocr_check_number: Optional[StrictStr] = Field(None, description="The unique check number for this check in the checkbook, included if OCR is successful and there is a check number on the check")
    ocr_routing_number: Optional[StrictStr] = Field(None, description="Routing number of the issuing bank, included if OCR is successful")
    person_id: Optional[StrictStr] = Field(None, description="Unique ID for the person. Exactly one of `person_id` or `business_id` must be set. ")
    status: StrictStr = Field(..., description="The status of the deposit")
    transaction_id: StrictStr = Field(..., description="The ID of the transaction associated with this deposit")
    vendor_info: VendorInfo1 = ...
    __properties = ["account_id", "back_image_id", "business_id", "check_amount", "creation_time", "date_captured", "date_processed", "deposit_amount", "deposit_currency", "front_image_id", "id", "last_updated_time", "metadata", "ocr_account_number", "ocr_check_number", "ocr_routing_number", "person_id", "status", "transaction_id", "vendor_info"]

    @validator('status')
    def status_validate_enum(cls, v):
        if v not in ('SUBMITTED', 'PENDING', 'FAILED', 'REJECTED'):
            raise ValueError("must validate the enum values ('SUBMITTED', 'PENDING', 'FAILED', 'REJECTED')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Deposit:
        """Create an instance of Deposit from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "creation_time",
                            "date_captured",
                            "date_processed",
                            "deposit_amount",
                            "id",
                            "last_updated_time",
                            "ocr_account_number",
                            "ocr_check_number",
                            "ocr_routing_number",
                            "status",
                            "transaction_id",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of vendor_info
        if self.vendor_info:
            _dict['vendor_info'] = self.vendor_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Deposit:
        """Create an instance of Deposit from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Deposit.parse_obj(obj)

        _obj = Deposit.parse_obj({
            "account_id": obj.get("account_id"),
            "back_image_id": obj.get("back_image_id"),
            "business_id": obj.get("business_id"),
            "check_amount": obj.get("check_amount"),
            "creation_time": obj.get("creation_time"),
            "date_captured": obj.get("date_captured"),
            "date_processed": obj.get("date_processed"),
            "deposit_amount": obj.get("deposit_amount"),
            "deposit_currency": obj.get("deposit_currency"),
            "front_image_id": obj.get("front_image_id"),
            "id": obj.get("id"),
            "last_updated_time": obj.get("last_updated_time"),
            "metadata": obj.get("metadata"),
            "ocr_account_number": obj.get("ocr_account_number"),
            "ocr_check_number": obj.get("ocr_check_number"),
            "ocr_routing_number": obj.get("ocr_routing_number"),
            "person_id": obj.get("person_id"),
            "status": obj.get("status"),
            "transaction_id": obj.get("transaction_id"),
            "vendor_info": VendorInfo1.from_dict(obj.get("vendor_info")) if obj.get("vendor_info") is not None else None
        })
        return _obj

