# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, validator
from synctera_client.models.raw_response import RawResponse
from synctera_client.models.verification_type import VerificationType
from synctera_client.models.verification_vendor_info import VerificationVendorInfo

class CustomerVerificationResult(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    id: Optional[StrictStr] = Field(None, description="Unique ID for this verification result.")
    issues: Optional[List[StrictStr]] = Field(None, description="List of potential problems found. These are subject to change. ")
    raw_response: Optional[RawResponse] = None
    result: StrictStr = Field(..., description="The determination of this verification.")
    vendor_info: Optional[VerificationVendorInfo] = None
    verification_time: datetime = Field(..., description="The date and time the verification was completed.")
    verification_type: VerificationType = ...
    __properties = ["id", "issues", "raw_response", "result", "vendor_info", "verification_time", "verification_type"]

    @validator('result')
    def result_validate_enum(cls, v):
        if v not in ('ACCEPTED', 'REJECTED', 'REVIEW', 'PROVIDER_FAILURE', 'PROVISIONAL'):
            raise ValueError("must validate the enum values ('ACCEPTED', 'REJECTED', 'REVIEW', 'PROVIDER_FAILURE', 'PROVISIONAL')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CustomerVerificationResult:
        """Create an instance of CustomerVerificationResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "id",
                            "issues",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of raw_response
        if self.raw_response:
            _dict['raw_response'] = self.raw_response.to_dict()
        # override the default output from pydantic by calling `to_dict()` of vendor_info
        if self.vendor_info:
            _dict['vendor_info'] = self.vendor_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CustomerVerificationResult:
        """Create an instance of CustomerVerificationResult from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CustomerVerificationResult.parse_obj(obj)

        _obj = CustomerVerificationResult.parse_obj({
            "id": obj.get("id"),
            "issues": obj.get("issues"),
            "raw_response": RawResponse.from_dict(obj.get("raw_response")) if obj.get("raw_response") is not None else None,
            "result": obj.get("result"),
            "vendor_info": VerificationVendorInfo.from_dict(obj.get("vendor_info")) if obj.get("vendor_info") is not None else None,
            "verification_time": obj.get("verification_time"),
            "verification_type": obj.get("verification_type")
        })
        return _obj

