# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, constr, validator
from synctera_client.models.verification_type import VerificationType

class CustomerVerification(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    customer_consent: StrictBool = Field(..., description="Whether this customer has consented to a KYC check. ")
    customer_ip_address: Optional[constr(strict=True)] = Field(None, description="IP address of the customer being verified.")
    document_id: Optional[StrictStr] = Field(None, description="The ID of the uploaded government-issued identification document provided by the Socure SDK. ")
    verification_type: Optional[List[VerificationType]] = Field(None, description="List of possible checks to run on a customer. This is a legacy field that is now ignored. ")
    __properties = ["customer_consent", "customer_ip_address", "document_id", "verification_type"]

    @validator('customer_ip_address')
    def customer_ip_address_validate_regular_expression(cls, v):
        if not re.match(r"^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$", v):
            raise ValueError(r"must validate the regular expression /^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CustomerVerification:
        """Create an instance of CustomerVerification from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CustomerVerification:
        """Create an instance of CustomerVerification from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CustomerVerification.parse_obj(obj)

        _obj = CustomerVerification.parse_obj({
            "customer_consent": obj.get("customer_consent"),
            "customer_ip_address": obj.get("customer_ip_address"),
            "document_id": obj.get("document_id"),
            "verification_type": obj.get("verification_type")
        })
        return _obj

