# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import date, datetime
from typing import Dict, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, constr, validator

class CashPickupPatchRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    account_id: StrictStr = ...
    amount: StrictInt = Field(..., description="The amount (in cents) of the transaction")
    business_id: Optional[StrictStr] = None
    creation_time: Optional[datetime] = None
    currency: Optional[constr(strict=True)] = None
    employee_customer_id: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    last_updated_time: Optional[datetime] = None
    metadata: Optional[Dict[str, StrictStr]] = None
    pickup_time: Optional[datetime] = Field(None, description="the date when the money was actually picked up")
    posted_amount: Optional[StrictInt] = None
    posted_date: Optional[date] = Field(None, description="The date the transaction was posted. This is the date any money is considered to be added or removed from an account.")
    reference_id: StrictStr = Field(..., description="An external ID provided by the partner. This is not guaranteed to be globally unique.")
    scheduled_pickup_date: Optional[date] = Field(None, description="the date when the money was expected to be picked up")
    transaction_id: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    __properties = ["account_id", "amount", "business_id", "creation_time", "currency", "employee_customer_id", "id", "last_updated_time", "metadata", "pickup_time", "posted_amount", "posted_date", "reference_id", "scheduled_pickup_date", "transaction_id", "status"]

    @validator('currency')
    def currency_validate_regular_expression(cls, v):
        if not re.match(r"^[A-Z]{3}$", v):
            raise ValueError(r"must validate the regular expression /^[A-Z]{3}$/")
        return v

    @validator('status')
    def status_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('CANCELED'):
            raise ValueError("must validate the enum values ('CANCELED')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CashPickupPatchRequest:
        """Create an instance of CashPickupPatchRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "creation_time",
                            "currency",
                            "id",
                            "last_updated_time",
                            "pickup_time",
                            "posted_amount",
                            "posted_date",
                            "transaction_id",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CashPickupPatchRequest:
        """Create an instance of CashPickupPatchRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CashPickupPatchRequest.parse_obj(obj)

        _obj = CashPickupPatchRequest.parse_obj({
            "account_id": obj.get("account_id"),
            "amount": obj.get("amount"),
            "business_id": obj.get("business_id"),
            "creation_time": obj.get("creation_time"),
            "currency": obj.get("currency"),
            "employee_customer_id": obj.get("employee_customer_id"),
            "id": obj.get("id"),
            "last_updated_time": obj.get("last_updated_time"),
            "metadata": obj.get("metadata"),
            "pickup_time": obj.get("pickup_time"),
            "posted_amount": obj.get("posted_amount"),
            "posted_date": obj.get("posted_date"),
            "reference_id": obj.get("reference_id"),
            "scheduled_pickup_date": obj.get("scheduled_pickup_date"),
            "transaction_id": obj.get("transaction_id"),
            "status": obj.get("status")
        })
        return _obj

