# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import json
import re  # noqa: F401

from typing import Any, List, Optional
from pydantic import BaseModel, Field, StrictStr, ValidationError, validator
from synctera_client.models.physical_card_response import PhysicalCardResponse
from synctera_client.models.virtual_card_response import VirtualCardResponse
from typing import Any, List
from pydantic import StrictStr, Field

CARDRESPONSE_ONE_OF_SCHEMAS = ["PhysicalCardResponse", "VirtualCardResponse"]

class CardResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    # data type: PhysicalCardResponse
    __oneof_schema_1: Optional[PhysicalCardResponse] = None
    # data type: VirtualCardResponse
    __oneof_schema_2: Optional[VirtualCardResponse] = None
    actual_instance: Any
    one_of_schemas: List[str] = Field(CARDRESPONSE_ONE_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    discriminator_value_class_map = {
    }

    @validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        error_messages = []
        match = 0
        # validate data type: PhysicalCardResponse
        if type(v) is not PhysicalCardResponse:
            error_messages.append(f"Error! Input type `{type(v)}` is not `PhysicalCardResponse`")
        else:
            match += 1

        # validate data type: VirtualCardResponse
        if type(v) is not VirtualCardResponse:
            error_messages.append(f"Error! Input type `{type(v)}` is not `VirtualCardResponse`")
        else:
            match += 1

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into CardResponse with oneOf schemas: PhysicalCardResponse, VirtualCardResponse. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into CardResponse with oneOf schemas: PhysicalCardResponse, VirtualCardResponse. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> CardResponse:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> CardResponse:
        """Returns the object represented by the json string"""
        instance = cls()
        error_messages = []
        match = 0

        # deserialize data into PhysicalCardResponse
        try:
            instance.actual_instance = PhysicalCardResponse.from_json(json_str)
            match += 1
        except ValidationError as e:
            error_messages.append(str(e))
        # deserialize data into VirtualCardResponse
        try:
            instance.actual_instance = VirtualCardResponse.from_json(json_str)
            match += 1
        except ValidationError as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into CardResponse with oneOf schemas: PhysicalCardResponse, VirtualCardResponse. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into CardResponse with oneOf schemas: PhysicalCardResponse, VirtualCardResponse. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is not None:
            return self.actual_instance.to_json()
        else:
            return "null"

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is not None:
            return self.actual_instance.to_dict()
        else:
            return dict()

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())





