# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, StrictBool, StrictStr, constr

class CardAcceptorModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    address: Optional[constr(strict=True, max_length=255, min_length=0)] = None
    city: Optional[constr(strict=True, max_length=40, min_length=0)] = None
    country: Optional[StrictStr] = None
    ecommerce_security_level_indicator: Optional[StrictStr] = None
    mcc: Optional[constr(strict=True, max_length=5, min_length=0)] = None
    name: Optional[constr(strict=True, max_length=50, min_length=0)] = None
    partial_approval_capable: Optional[StrictBool] = False
    state: Optional[StrictStr] = None
    zip: Optional[constr(strict=True, max_length=10, min_length=0)] = None
    __properties = ["address", "city", "country", "ecommerce_security_level_indicator", "mcc", "name", "partial_approval_capable", "state", "zip"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CardAcceptorModel:
        """Create an instance of CardAcceptorModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CardAcceptorModel:
        """Create an instance of CardAcceptorModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CardAcceptorModel.parse_obj(obj)

        _obj = CardAcceptorModel.parse_obj({
            "address": obj.get("address"),
            "city": obj.get("city"),
            "country": obj.get("country"),
            "ecommerce_security_level_indicator": obj.get("ecommerce_security_level_indicator"),
            "mcc": obj.get("mcc"),
            "name": obj.get("name"),
            "partial_approval_capable": obj.get("partial_approval_capable") if obj.get("partial_approval_capable") is not None else False,
            "state": obj.get("state"),
            "zip": obj.get("zip")
        })
        return _obj

