# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, constr
from synctera_client.models.bin_status import BinStatus
from synctera_client.models.card_brand import CardBrand
from synctera_client.models.card_category import CardCategory
from synctera_client.models.card_product_type import CardProductType
from synctera_client.models.physical_card_format import PhysicalCardFormat

class BinResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    account_range_length: StrictInt = Field(..., description="Account range length")
    bank_id: StrictInt = Field(..., description="The bank ID")
    billing_ica: StrictStr = Field(..., description="The ICA to which fees will be billed")
    bin: StrictStr = Field(..., description="The bin number")
    bin_status: BinStatus = ...
    brand_product_code: constr(strict=True, max_length=3, min_length=3) = Field(..., description="The Mastercard or Visa Product Code - 3 alpha-numeric characters")
    card_brand: CardBrand = ...
    card_category: CardCategory = ...
    card_product_type: CardProductType = ...
    country: constr(strict=True, max_length=2, min_length=2) = Field(..., description="ISO-3166-1 Alpha-2 country code")
    creation_time: datetime = Field(..., description="The timestamp representing when the bin was created")
    currency: constr(strict=True, max_length=3, min_length=3) = Field(..., description="ISO 4217  Alpha-3 currency code")
    digital_wallet_active: Optional[StrictBool] = Field(False, description="Determines if bin supports digital wallet tokenization")
    end_date: Optional[datetime] = Field(None, description="The time when bin is decommissioned")
    ica_bid: StrictStr = Field(..., description="ICA/BID")
    id: StrictStr = Field(..., description="Bin ID")
    is_tokenization_enabled: StrictBool = Field(..., description="Controls whether bin allows tokenization")
    last_modified_time: datetime = Field(..., description="The timestamp representing when the bin was last modified")
    pan_utilization: StrictInt = Field(..., description="Pan utilization")
    partner_id: StrictInt = Field(..., description="The partner ID")
    physical_card_format: Optional[PhysicalCardFormat] = None
    processor: StrictStr = Field(..., description="The name of the card processor")
    start_date: Optional[datetime] = Field(None, description="The time when bin goes live")
    __properties = ["account_range_length", "bank_id", "billing_ica", "bin", "bin_status", "brand_product_code", "card_brand", "card_category", "card_product_type", "country", "creation_time", "currency", "digital_wallet_active", "end_date", "ica_bid", "id", "is_tokenization_enabled", "last_modified_time", "pan_utilization", "partner_id", "physical_card_format", "processor", "start_date"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BinResponse:
        """Create an instance of BinResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "creation_time",
                            "id",
                            "last_modified_time",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BinResponse:
        """Create an instance of BinResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return BinResponse.parse_obj(obj)

        _obj = BinResponse.parse_obj({
            "account_range_length": obj.get("account_range_length"),
            "bank_id": obj.get("bank_id"),
            "billing_ica": obj.get("billing_ica"),
            "bin": obj.get("bin"),
            "bin_status": obj.get("bin_status"),
            "brand_product_code": obj.get("brand_product_code"),
            "card_brand": obj.get("card_brand"),
            "card_category": obj.get("card_category"),
            "card_product_type": obj.get("card_product_type"),
            "country": obj.get("country"),
            "creation_time": obj.get("creation_time"),
            "currency": obj.get("currency"),
            "digital_wallet_active": obj.get("digital_wallet_active") if obj.get("digital_wallet_active") is not None else False,
            "end_date": obj.get("end_date"),
            "ica_bid": obj.get("ica_bid"),
            "id": obj.get("id"),
            "is_tokenization_enabled": obj.get("is_tokenization_enabled") if obj.get("is_tokenization_enabled") is not None else False,
            "last_modified_time": obj.get("last_modified_time"),
            "pan_utilization": obj.get("pan_utilization"),
            "partner_id": obj.get("partner_id"),
            "physical_card_format": obj.get("physical_card_format"),
            "processor": obj.get("processor"),
            "start_date": obj.get("start_date")
        })
        return _obj

