# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr

class BinNetworkMapping(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    active: StrictBool = Field(..., description="indicates whether mapping is active")
    bank_network_id: StrictStr = Field(..., description="ID debit network uses to identify a bank")
    bin_id: StrictStr = Field(..., description="The ID of the bank's BIN that uses this debit network")
    creation_time: Optional[datetime] = Field(None, description="The timestamp representing when BIN network mapping was created")
    end_date: Optional[datetime] = Field(None, description="The time when mapping becomes inactive")
    last_modified_time: Optional[datetime] = Field(None, description="The timestamp representing when the BIN network mapping was last modified")
    network_id: StrictStr = Field(..., description="The ID of the debit_network associated with the BIN of the bank")
    start_date: Optional[datetime] = Field(None, description="The time when mapping becomes active")
    __properties = ["active", "bank_network_id", "bin_id", "creation_time", "end_date", "last_modified_time", "network_id", "start_date"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BinNetworkMapping:
        """Create an instance of BinNetworkMapping from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "creation_time",
                            "last_modified_time",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BinNetworkMapping:
        """Create an instance of BinNetworkMapping from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return BinNetworkMapping.parse_obj(obj)

        _obj = BinNetworkMapping.parse_obj({
            "active": obj.get("active"),
            "bank_network_id": obj.get("bank_network_id"),
            "bin_id": obj.get("bin_id"),
            "creation_time": obj.get("creation_time"),
            "end_date": obj.get("end_date"),
            "last_modified_time": obj.get("last_modified_time"),
            "network_id": obj.get("network_id"),
            "start_date": obj.get("start_date")
        })
        return _obj

