# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr
from synctera_client.models.bin_and_debit_network import BinAndDebitNetwork

class BinAndDebitNetworkList(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    bin_and_debit_networks: List[BinAndDebitNetwork] = Field(..., description="Array of BINs and debit networks")
    next_page_token: Optional[StrictStr] = Field(None, description="If returned, use the next_page_token to query for the next page of results. Not returned if there are no more rows.")
    __properties = ["bin_and_debit_networks", "next_page_token"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BinAndDebitNetworkList:
        """Create an instance of BinAndDebitNetworkList from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in bin_and_debit_networks (list)
        _items = []
        if self.bin_and_debit_networks:
            for _item in self.bin_and_debit_networks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['bin_and_debit_networks'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BinAndDebitNetworkList:
        """Create an instance of BinAndDebitNetworkList from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return BinAndDebitNetworkList.parse_obj(obj)

        _obj = BinAndDebitNetworkList.parse_obj({
            "bin_and_debit_networks": [BinAndDebitNetwork.from_dict(_item) for _item in obj.get("bin_and_debit_networks")] if obj.get("bin_and_debit_networks") is not None else None,
            "next_page_token": obj.get("next_page_token")
        })
        return _obj

