# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime

from pydantic import BaseModel, Field, StrictStr, validator

class BillingPeriod(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    frequency: StrictStr = Field(..., description="The frequency of billing cycles. Along with the start date, this will determine the start and end of each cycle. ")
    start_date: datetime = Field(..., description="The first day of the first billing cycle for this account. For a monthly billing cycle, this would determine the day of the month each billing cycle will start on. ")
    __properties = ["frequency", "start_date"]

    @validator('frequency')
    def frequency_validate_enum(cls, v):
        if v not in ('ANNUALLY', 'MONTHLY', 'SEMI_MONTHLY', 'BI_WEEKLY', 'WEEKLY', 'DAILY'):
            raise ValueError("must validate the enum values ('ANNUALLY', 'MONTHLY', 'SEMI_MONTHLY', 'BI_WEEKLY', 'WEEKLY', 'DAILY')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BillingPeriod:
        """Create an instance of BillingPeriod from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BillingPeriod:
        """Create an instance of BillingPeriod from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return BillingPeriod.parse_obj(obj)

        _obj = BillingPeriod.parse_obj({
            "frequency": obj.get("frequency"),
            "start_date": obj.get("start_date")
        })
        return _obj

