# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import date
from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr
from synctera_client.models.account_summary import AccountSummary
from synctera_client.models.business1 import Business1
from synctera_client.models.person1 import Person1
from synctera_client.models.transaction import Transaction

class BaseStatement(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    account_id: Optional[StrictStr] = Field(None, description="The unique identifier of the account the statement belongs to")
    due_date: Optional[date] = Field(None, description="The limit date when the due amount indicated on the statement should be paid")
    end_date: Optional[date] = Field(None, description="The date indicating the ending of the time interval covered by the statement")
    id: Optional[StrictStr] = Field(None, description="statement ID")
    issue_date: Optional[date] = Field(None, description="The date when the statement has been issued")
    start_date: Optional[date] = Field(None, description="The date indicating the beginning of the time interval covered by the statement")
    account_summary: Optional[AccountSummary] = None
    authorized_signer: Optional[List[Person1]] = None
    disclosure: Optional[StrictStr] = None
    joint_account_holders: Optional[List[Person1]] = None
    primary_account_holder_business: Optional[Business1] = None
    primary_account_holder_personal: Optional[Person1] = None
    transactions: Optional[List[Transaction]] = None
    __properties = ["account_id", "due_date", "end_date", "id", "issue_date", "start_date", "account_summary", "authorized_signer", "disclosure", "joint_account_holders", "primary_account_holder_business", "primary_account_holder_personal", "transactions"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BaseStatement:
        """Create an instance of BaseStatement from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "account_id",
                            "due_date",
                            "end_date",
                            "id",
                            "issue_date",
                            "start_date",
                            "authorized_signer",
                            "joint_account_holders",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of account_summary
        if self.account_summary:
            _dict['account_summary'] = self.account_summary.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in authorized_signer (list)
        _items = []
        if self.authorized_signer:
            for _item in self.authorized_signer:
                if _item:
                    _items.append(_item.to_dict())
            _dict['authorized_signer'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in joint_account_holders (list)
        _items = []
        if self.joint_account_holders:
            for _item in self.joint_account_holders:
                if _item:
                    _items.append(_item.to_dict())
            _dict['joint_account_holders'] = _items
        # override the default output from pydantic by calling `to_dict()` of primary_account_holder_business
        if self.primary_account_holder_business:
            _dict['primary_account_holder_business'] = self.primary_account_holder_business.to_dict()
        # override the default output from pydantic by calling `to_dict()` of primary_account_holder_personal
        if self.primary_account_holder_personal:
            _dict['primary_account_holder_personal'] = self.primary_account_holder_personal.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in transactions (list)
        _items = []
        if self.transactions:
            for _item in self.transactions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['transactions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BaseStatement:
        """Create an instance of BaseStatement from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return BaseStatement.parse_obj(obj)

        _obj = BaseStatement.parse_obj({
            "account_id": obj.get("account_id"),
            "due_date": obj.get("due_date"),
            "end_date": obj.get("end_date"),
            "id": obj.get("id"),
            "issue_date": obj.get("issue_date"),
            "start_date": obj.get("start_date"),
            "account_summary": AccountSummary.from_dict(obj.get("account_summary")) if obj.get("account_summary") is not None else None,
            "authorized_signer": [Person1.from_dict(_item) for _item in obj.get("authorized_signer")] if obj.get("authorized_signer") is not None else None,
            "disclosure": obj.get("disclosure"),
            "joint_account_holders": [Person1.from_dict(_item) for _item in obj.get("joint_account_holders")] if obj.get("joint_account_holders") is not None else None,
            "primary_account_holder_business": Business1.from_dict(obj.get("primary_account_holder_business")) if obj.get("primary_account_holder_business") is not None else None,
            "primary_account_holder_personal": Person1.from_dict(obj.get("primary_account_holder_personal")) if obj.get("primary_account_holder_personal") is not None else None,
            "transactions": [Transaction.from_dict(_item) for _item in obj.get("transactions")] if obj.get("transactions") is not None else None
        })
        return _obj

