# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, constr, validator
from synctera_client.models.address import Address
from synctera_client.models.ban_status import BanStatus
from synctera_client.models.customer_kyc_status import CustomerKycStatus
from synctera_client.models.relationship1 import Relationship1
from synctera_client.models.ssn_source import SsnSource

class BasePerson(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    ban_status: Optional[BanStatus] = None
    creation_time: Optional[datetime] = Field(None, description="The date and time the resource was created.")
    email: Optional[StrictStr] = Field(None, description="Customer's email")
    id: Optional[StrictStr] = Field(None, description="Customer unique identifier")
    kyc_exempt: Optional[StrictBool] = Field(None, description="Customer's KYC exemption")
    kyc_last_run: Optional[datetime] = Field(None, description="Date and time KYC was last run on the customer")
    kyc_status: Optional[CustomerKycStatus] = None
    last_updated_time: Optional[datetime] = Field(None, description="The date and time the resource was last updated.")
    legal_address: Optional[Address] = None
    metadata: Optional[Dict[str, Any]] = Field(None, description="User-supplied metadata. Do not use to store PII.")
    middle_name: Optional[StrictStr] = Field(None, description="Customer's middle name")
    phone_number: Optional[constr(strict=True)] = Field(None, description="Customer's mobile phone number with country code in E.164 format. Must have a valid country code. Area code and local phone number are not validated.")
    related_customers: Optional[List[Relationship1]] = Field(None, description="Customer's relationships with other accounts eg. guardian")
    shipping_address: Optional[Address] = None
    ssn: Optional[StrictStr] = Field(None, description="Customer's full tax ID eg SSN formatted with hyphens. This optional parameter is required when running KYC on a customer. Input must match the pattern ^\\d{3}-\\d{2}-\\d{4}$. The response contains the last 4 digits only (e.g. 6789).")
    ssn_source: Optional[SsnSource] = None
    tenant: Optional[StrictStr] = Field(None, description="The id of the tenant containing the resource. ")
    __properties = ["ban_status", "creation_time", "email", "id", "kyc_exempt", "kyc_last_run", "kyc_status", "last_updated_time", "legal_address", "metadata", "middle_name", "phone_number", "related_customers", "shipping_address", "ssn", "ssn_source", "tenant"]

    @validator('phone_number')
    def phone_number_validate_regular_expression(cls, v):
        if not re.match(r"^\+[1-9]\d{1,14}$", v):
            raise ValueError(r"must validate the regular expression /^\+[1-9]\d{1,14}$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BasePerson:
        """Create an instance of BasePerson from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "creation_time",
                            "id",
                            "kyc_exempt",
                            "kyc_last_run",
                            "last_updated_time",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of legal_address
        if self.legal_address:
            _dict['legal_address'] = self.legal_address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in related_customers (list)
        _items = []
        if self.related_customers:
            for _item in self.related_customers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['related_customers'] = _items
        # override the default output from pydantic by calling `to_dict()` of shipping_address
        if self.shipping_address:
            _dict['shipping_address'] = self.shipping_address.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BasePerson:
        """Create an instance of BasePerson from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return BasePerson.parse_obj(obj)

        _obj = BasePerson.parse_obj({
            "ban_status": obj.get("ban_status"),
            "creation_time": obj.get("creation_time"),
            "email": obj.get("email"),
            "id": obj.get("id"),
            "kyc_exempt": obj.get("kyc_exempt"),
            "kyc_last_run": obj.get("kyc_last_run"),
            "kyc_status": obj.get("kyc_status"),
            "last_updated_time": obj.get("last_updated_time"),
            "legal_address": Address.from_dict(obj.get("legal_address")) if obj.get("legal_address") is not None else None,
            "metadata": obj.get("metadata"),
            "middle_name": obj.get("middle_name"),
            "phone_number": obj.get("phone_number"),
            "related_customers": [Relationship1.from_dict(_item) for _item in obj.get("related_customers")] if obj.get("related_customers") is not None else None,
            "shipping_address": Address.from_dict(obj.get("shipping_address")) if obj.get("shipping_address") is not None else None,
            "ssn": obj.get("ssn"),
            "ssn_source": obj.get("ssn_source"),
            "tenant": obj.get("tenant")
        })
        return _obj

