# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictStr, constr, validator
from synctera_client.models.disclosure_type import DisclosureType

class BaseMasterDisclosure(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    creation_time: Optional[datetime] = Field(None, description="The date and time the resource was created.")
    document_id: Optional[StrictStr] = Field(None, description="ID of disclosure document.")
    id: Optional[StrictStr] = Field(None, description="The unique identifier for this resource.")
    last_updated_time: Optional[datetime] = Field(None, description="The date and time the resource was last updated.")
    metadata: Optional[Dict[str, Any]] = Field(None, description="Optional field to store additional information about the resource. Intended to be used by the integrator to store non-sensitive data. ")
    tenant: Optional[StrictStr] = Field(None, description="The id of the tenant containing the resource. ")
    type: Optional[DisclosureType] = None
    version: Optional[constr(strict=True)] = Field(None, description="Version of the disclosure document.")
    __properties = ["creation_time", "document_id", "id", "last_updated_time", "metadata", "tenant", "type", "version"]

    @validator('version')
    def version_validate_regular_expression(cls, v):
        if not re.match(r"^v?[0-9]+\.[0-9]+$", v):
            raise ValueError(r"must validate the regular expression /^v?[0-9]+\.[0-9]+$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BaseMasterDisclosure:
        """Create an instance of BaseMasterDisclosure from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "creation_time",
                            "id",
                            "last_updated_time",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BaseMasterDisclosure:
        """Create an instance of BaseMasterDisclosure from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return BaseMasterDisclosure.parse_obj(obj)

        _obj = BaseMasterDisclosure.parse_obj({
            "creation_time": obj.get("creation_time"),
            "document_id": obj.get("document_id"),
            "id": obj.get("id"),
            "last_updated_time": obj.get("last_updated_time"),
            "metadata": obj.get("metadata"),
            "tenant": obj.get("tenant"),
            "type": obj.get("type"),
            "version": obj.get("version")
        })
        return _obj

