# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictStr, constr, validator
from synctera_client.models.disclosure_type import DisclosureType

class BaseDisclosure(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    business_id: Optional[StrictStr] = Field(None, description="Unique ID for the business. Exactly one of `business_id` or `person_id` must be set. ")
    creation_time: Optional[datetime] = Field(None, description="The date and time the resource was created.")
    disclosure_date: Optional[datetime] = Field(None, description="Date and time the disclosure was made.")
    event_type: Optional[StrictStr] = Field(None, description="Describes how the disclosure was shown and what the user did as a result. One of the following: * `DISPLAYED` —     The document was made visible to the user,     but they did not interact with it. * `VIEWED` —     The document was made visible to the user,     and they interacted enough to see the whole document (e.g. scrolled to the bottom). * `ACKNOWLEDGED` —     The document was made visible to the user,     and they took positive action to confirm that they have read and accepted the document. ")
    id: Optional[StrictStr] = Field(None, description="The unique identifier for this resource.")
    last_updated_time: Optional[datetime] = Field(None, description="The date and time the resource was last updated.")
    metadata: Optional[Dict[str, Any]] = Field(None, description="Optional field to store additional information about the resource. Intended to be used by the integrator to store non-sensitive data. ")
    person_id: Optional[StrictStr] = Field(None, description="Unique ID for the person. Exactly one of `person_id` or `business_id` must be set. ")
    type: Optional[DisclosureType] = None
    version: Optional[constr(strict=True)] = Field(None, description="Version of the disclosure document.")
    __properties = ["business_id", "creation_time", "disclosure_date", "event_type", "id", "last_updated_time", "metadata", "person_id", "type", "version"]

    @validator('event_type')
    def event_type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('DISPLAYED', 'VIEWED', 'ACKNOWLEDGED'):
            raise ValueError("must validate the enum values ('DISPLAYED', 'VIEWED', 'ACKNOWLEDGED')")
        return v

    @validator('version')
    def version_validate_regular_expression(cls, v):
        if not re.match(r"^v?[0-9]+\.[0-9]+$", v):
            raise ValueError(r"must validate the regular expression /^v?[0-9]+\.[0-9]+$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BaseDisclosure:
        """Create an instance of BaseDisclosure from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "creation_time",
                            "id",
                            "last_updated_time",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BaseDisclosure:
        """Create an instance of BaseDisclosure from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return BaseDisclosure.parse_obj(obj)

        _obj = BaseDisclosure.parse_obj({
            "business_id": obj.get("business_id"),
            "creation_time": obj.get("creation_time"),
            "disclosure_date": obj.get("disclosure_date"),
            "event_type": obj.get("event_type"),
            "id": obj.get("id"),
            "last_updated_time": obj.get("last_updated_time"),
            "metadata": obj.get("metadata"),
            "person_id": obj.get("person_id"),
            "type": obj.get("type"),
            "version": obj.get("version")
        })
        return _obj

