# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr

class BankDebitNetworkResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    active: Optional[StrictBool] = Field(None, description="indicates whether debit network is active")
    creation_time: Optional[datetime] = Field(None, description="The timestamp representing when the debit network was created")
    end_date: Optional[datetime] = Field(None, description="The time when debit network became inactive")
    id: Optional[StrictStr] = Field(None, description="Debit Network ID")
    last_modified_time: Optional[datetime] = Field(None, description="The timestamp representing when the debit network was last modified")
    name: Optional[StrictStr] = Field(None, description="The name describing the debit network")
    start_date: Optional[datetime] = Field(None, description="The time when debit network goes live")
    bank_network_id: Optional[StrictStr] = Field(None, description="The ID of the bank network")
    bin_id: Optional[StrictStr] = Field(None, description="The ID of the bank's bin that uses this debit network")
    __properties = ["active", "creation_time", "end_date", "id", "last_modified_time", "name", "start_date", "bank_network_id", "bin_id"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BankDebitNetworkResponse:
        """Create an instance of BankDebitNetworkResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "creation_time",
                            "id",
                            "last_modified_time",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BankDebitNetworkResponse:
        """Create an instance of BankDebitNetworkResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return BankDebitNetworkResponse.parse_obj(obj)

        _obj = BankDebitNetworkResponse.parse_obj({
            "active": obj.get("active"),
            "creation_time": obj.get("creation_time"),
            "end_date": obj.get("end_date"),
            "id": obj.get("id"),
            "last_modified_time": obj.get("last_modified_time"),
            "name": obj.get("name"),
            "start_date": obj.get("start_date"),
            "bank_network_id": obj.get("bank_network_id"),
            "bin_id": obj.get("bin_id")
        })
        return _obj

