# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, StrictStr, constr, validator
from synctera_client.models.card_acceptor_model import CardAcceptorModel
from synctera_client.models.network_fee_model import NetworkFeeModel

class BalanceInquiryRequestModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    account_type: StrictStr = ...
    card_acceptor: CardAcceptorModel = ...
    card_id: StrictStr = ...
    mid: constr(strict=True, max_length=50, min_length=1) = ...
    network_fees: Optional[List[NetworkFeeModel]] = None
    pin: Optional[constr(strict=True, max_length=15, min_length=1)] = None
    __properties = ["account_type", "card_acceptor", "card_id", "mid", "network_fees", "pin"]

    @validator('account_type')
    def account_type_validate_enum(cls, v):
        if v not in ('checking', 'savings', 'credit'):
            raise ValueError("must validate the enum values ('checking', 'savings', 'credit')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BalanceInquiryRequestModel:
        """Create an instance of BalanceInquiryRequestModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of card_acceptor
        if self.card_acceptor:
            _dict['card_acceptor'] = self.card_acceptor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in network_fees (list)
        _items = []
        if self.network_fees:
            for _item in self.network_fees:
                if _item:
                    _items.append(_item.to_dict())
            _dict['network_fees'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BalanceInquiryRequestModel:
        """Create an instance of BalanceInquiryRequestModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return BalanceInquiryRequestModel.parse_obj(obj)

        _obj = BalanceInquiryRequestModel.parse_obj({
            "account_type": obj.get("account_type"),
            "card_acceptor": CardAcceptorModel.from_dict(obj.get("card_acceptor")) if obj.get("card_acceptor") is not None else None,
            "card_id": obj.get("card_id"),
            "mid": obj.get("mid"),
            "network_fees": [NetworkFeeModel.from_dict(_item) for _item in obj.get("network_fees")] if obj.get("network_fees") is not None else None,
            "pin": obj.get("pin")
        })
        return _obj

