# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel
from synctera_client.models.add_vendor_account_failure import AddVendorAccountFailure
from synctera_client.models.external_account import ExternalAccount

class AddVendorAccountsResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    added_accounts: List[ExternalAccount] = ...
    deleted_accounts: Optional[List[ExternalAccount]] = None
    failed_accounts: List[AddVendorAccountFailure] = ...
    __properties = ["added_accounts", "deleted_accounts", "failed_accounts"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AddVendorAccountsResponse:
        """Create an instance of AddVendorAccountsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in added_accounts (list)
        _items = []
        if self.added_accounts:
            for _item in self.added_accounts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['added_accounts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in deleted_accounts (list)
        _items = []
        if self.deleted_accounts:
            for _item in self.deleted_accounts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['deleted_accounts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in failed_accounts (list)
        _items = []
        if self.failed_accounts:
            for _item in self.failed_accounts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['failed_accounts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AddVendorAccountsResponse:
        """Create an instance of AddVendorAccountsResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AddVendorAccountsResponse.parse_obj(obj)

        _obj = AddVendorAccountsResponse.parse_obj({
            "added_accounts": [ExternalAccount.from_dict(_item) for _item in obj.get("added_accounts")] if obj.get("added_accounts") is not None else None,
            "deleted_accounts": [ExternalAccount.from_dict(_item) for _item in obj.get("deleted_accounts")] if obj.get("deleted_accounts") is not None else None,
            "failed_accounts": [AddVendorAccountFailure.from_dict(_item) for _item in obj.get("failed_accounts")] if obj.get("failed_accounts") is not None else None
        })
        return _obj

