# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import date

from pydantic import BaseModel, Field, StrictInt, StrictStr, validator

class AchTransactionSimulationRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    account_number: StrictStr = Field(..., description="Number of the receiving account")
    amount: StrictInt = Field(..., description="Amount to transfer in cents (e.g. 100 = $1).")
    dc_sign: StrictStr = Field(..., description="The type of transaction (debit or credit) in relation to the receiving account. A credit is a transfer in and a debit is a transfer pulling money out of the receiving account.")
    effective_date: date = Field(..., description="Effective date of the transaction. Transactions with the current date or date in the past are posted immediately. Future-dated transactions are scheduled to be posted on the chosen date.")
    __properties = ["account_number", "amount", "dc_sign", "effective_date"]

    @validator('dc_sign')
    def dc_sign_validate_enum(cls, v):
        if v not in ('debit', 'credit'):
            raise ValueError("must validate the enum values ('debit', 'credit')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AchTransactionSimulationRequest:
        """Create an instance of AchTransactionSimulationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AchTransactionSimulationRequest:
        """Create an instance of AchTransactionSimulationRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AchTransactionSimulationRequest.parse_obj(obj)

        _obj = AchTransactionSimulationRequest.parse_obj({
            "account_number": obj.get("account_number"),
            "amount": obj.get("amount"),
            "dc_sign": obj.get("dc_sign"),
            "effective_date": obj.get("effective_date")
        })
        return _obj

