# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class AchTransactionData(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    description: Optional[StrictStr] = Field(None, description="The ACH company entry description")
    file_name: Optional[StrictStr] = Field(None, description="For outgoing ACH, the name of the file the entry went out in. For incoming ACH, the name of the file the entry came from. The value will be omitted for outgoing payments that have not yet been written into a file.")
    id: StrictStr = Field(..., description="The ACH payment uuid (used in `/v0/ach` endpoint)")
    originating_account_id: Optional[StrictStr] = Field(None, description="The uuid of the account originating the ACH. This will be a customer account uuid for outgoing ACH, and omitted for incoming ACH.")
    originator_name: Optional[StrictStr] = Field(None, description="The name of the originator according to the ACH entry. This should map to the ACH `Identification Number` field, if provided.")
    receiving_account_id: Optional[StrictStr] = Field(None, description="The uuid of the account receiving the ACH entry. In the case of an outgoing ACH, this will be an external_account uuid. For incoming ACH, this will be an account uuid.")
    recipient_name: Optional[StrictStr] = Field(None, description="The name of the recipient according to the ACH entry. This should map to the ACH `Individual Name` field.")
    return_code: Optional[StrictStr] = Field(None, description="The ACH return code, if this transaction was a return")
    trace_number: Optional[StrictStr] = Field(None, description="The ACH trace number associated with the transaction")
    __properties = ["description", "file_name", "id", "originating_account_id", "originator_name", "receiving_account_id", "recipient_name", "return_code", "trace_number"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AchTransactionData:
        """Create an instance of AchTransactionData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AchTransactionData:
        """Create an instance of AchTransactionData from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AchTransactionData.parse_obj(obj)

        _obj = AchTransactionData.parse_obj({
            "description": obj.get("description"),
            "file_name": obj.get("file_name"),
            "id": obj.get("id"),
            "originating_account_id": obj.get("originating_account_id"),
            "originator_name": obj.get("originator_name"),
            "receiving_account_id": obj.get("receiving_account_id"),
            "recipient_name": obj.get("recipient_name"),
            "return_code": obj.get("return_code"),
            "trace_number": obj.get("trace_number")
        })
        return _obj

