# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr
from synctera_client.models.template_fields_generic_response import TemplateFieldsGenericResponse

class AccountTemplateResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    application_type: Optional[StrictStr] = None
    description: Optional[StrictStr] = Field(None, description="Account template description")
    id: Optional[StrictStr] = Field(None, description="Generated ID for the template")
    is_enabled: StrictBool = Field(..., description="Whether this template can be used for account creation")
    name: StrictStr = Field(..., description="Unique account template name")
    template: TemplateFieldsGenericResponse = ...
    tenant: Optional[StrictStr] = Field(None, description="The id of the tenant containing the resource. ")
    __properties = ["application_type", "description", "id", "is_enabled", "name", "template", "tenant"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccountTemplateResponse:
        """Create an instance of AccountTemplateResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of template
        if self.template:
            _dict['template'] = self.template.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AccountTemplateResponse:
        """Create an instance of AccountTemplateResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AccountTemplateResponse.parse_obj(obj)

        _obj = AccountTemplateResponse.parse_obj({
            "application_type": obj.get("application_type"),
            "description": obj.get("description"),
            "id": obj.get("id"),
            "is_enabled": obj.get("is_enabled"),
            "name": obj.get("name"),
            "template": TemplateFieldsGenericResponse.from_dict(obj.get("template")) if obj.get("template") is not None else None,
            "tenant": obj.get("tenant")
        })
        return _obj

