# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr, validator
from synctera_client.models.account_summary_balance_ceiling import AccountSummaryBalanceCeiling
from synctera_client.models.account_summary_balance_floor import AccountSummaryBalanceFloor
from synctera_client.models.financial_institution import FinancialInstitution

class AccountSummary(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    account_number: Optional[StrictStr] = Field(None, description="Account number")
    account_status: Optional[StrictStr] = Field(None, description="Account Status")
    account_type: Optional[StrictStr] = Field(None, description="The type of the account. In lead mode, this always takes the value of the template. If not specified in shadow mode, CHECKING will be assumed. ")
    balance_ceiling: Optional[AccountSummaryBalanceCeiling] = None
    balance_floor: Optional[AccountSummaryBalanceFloor] = None
    creation_time: Optional[datetime] = Field(None, description="Account creation time")
    currency: Optional[constr(strict=True)] = Field(None, description="Account currency or account settlement currency. ISO 4217 alphabetic currency code. Default USD")
    customer_type: Optional[StrictStr] = Field(None, description="Customer type")
    financial_institution: Optional[FinancialInstitution] = None
    id: Optional[StrictStr] = Field(None, description="The unique identifier of the account the statement belongs to")
    last_updated_time: Optional[datetime] = Field(None, description="Account last modification time")
    nickname: Optional[StrictStr] = Field(None, description="User provided account nickname")
    __properties = ["account_number", "account_status", "account_type", "balance_ceiling", "balance_floor", "creation_time", "currency", "customer_type", "financial_institution", "id", "last_updated_time", "nickname"]

    @validator('currency')
    def currency_validate_regular_expression(cls, v):
        if not re.match(r"^[A-Z]{3}$", v):
            raise ValueError(r"must validate the regular expression /^[A-Z]{3}$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccountSummary:
        """Create an instance of AccountSummary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of balance_ceiling
        if self.balance_ceiling:
            _dict['balance_ceiling'] = self.balance_ceiling.to_dict()
        # override the default output from pydantic by calling `to_dict()` of balance_floor
        if self.balance_floor:
            _dict['balance_floor'] = self.balance_floor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of financial_institution
        if self.financial_institution:
            _dict['financial_institution'] = self.financial_institution.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AccountSummary:
        """Create an instance of AccountSummary from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AccountSummary.parse_obj(obj)

        _obj = AccountSummary.parse_obj({
            "account_number": obj.get("account_number"),
            "account_status": obj.get("account_status"),
            "account_type": obj.get("account_type"),
            "balance_ceiling": AccountSummaryBalanceCeiling.from_dict(obj.get("balance_ceiling")) if obj.get("balance_ceiling") is not None else None,
            "balance_floor": AccountSummaryBalanceFloor.from_dict(obj.get("balance_floor")) if obj.get("balance_floor") is not None else None,
            "creation_time": obj.get("creation_time"),
            "currency": obj.get("currency"),
            "customer_type": obj.get("customer_type"),
            "financial_institution": FinancialInstitution.from_dict(obj.get("financial_institution")) if obj.get("financial_institution") is not None else None,
            "id": obj.get("id"),
            "last_updated_time": obj.get("last_updated_time"),
            "nickname": obj.get("nickname")
        })
        return _obj

