# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, validator

class AccountRouting(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    ach_routing_number: Optional[StrictStr] = Field(None, description="The routing number used for US ACH payments. Only appears if `bank_countries` contains `US`. Value may be masked, in which case only the last four digits are returned. ")
    bank_countries: List[StrictStr] = Field(..., description="The countries that this bank operates the account in")
    bank_name: StrictStr = Field(..., description="The name of the bank managing the account")
    eft_routing_number: Optional[StrictStr] = Field(None, description="The routing number used for EFT payments, identifying a Canadian bank, consisting of the institution number and the branch number. Only appears if `bank_countries` contains `CA`. Value may be masked, in which case only the last four digits are returned. ")
    swift_code: Optional[StrictStr] = Field(None, description="The SWIFT code for the bank. Value may be masked, in which case only the last four characters are returned. ")
    wire_routing_number: Optional[StrictStr] = Field(None, description="The routing number used for domestic wire payments. Only appears if `bank_countries` contains `US`. Value may be masked, in which case only the last four digits are returned. ")
    __properties = ["ach_routing_number", "bank_countries", "bank_name", "eft_routing_number", "swift_code", "wire_routing_number"]

    @validator('bank_countries')
    def bank_countries_validate_enum(cls, v):
        if v not in ('US', 'CA'):
            raise ValueError("must validate the enum values ('US', 'CA')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccountRouting:
        """Create an instance of AccountRouting from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AccountRouting:
        """Create an instance of AccountRouting from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AccountRouting.parse_obj(obj)

        _obj = AccountRouting.parse_obj({
            "ach_routing_number": obj.get("ach_routing_number"),
            "bank_countries": obj.get("bank_countries"),
            "bank_name": obj.get("bank_name"),
            "eft_routing_number": obj.get("eft_routing_number"),
            "swift_code": obj.get("swift_code"),
            "wire_routing_number": obj.get("wire_routing_number")
        })
        return _obj

