# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, conint
from synctera_client.models.minimum_payment_partial import MinimumPaymentPartial

class AccountLineOfCreditAllOf(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    chargeoff_period: Optional[conint(strict=True, ge=0)] = Field(90, description="The number of days an account can stay delinquent before marking an account as charged-off. ")
    credit_limit: Optional[conint(strict=True, ge=0)] = Field(None, description="The credit limit for this line of credit account in cents. Minimum is 0. ")
    delinquency_period: Optional[conint(strict=True, ge=0)] = Field(30, description="The number of days past the due date to wait for a minimum payment before marking an account as delinquent. ")
    grace_period: Optional[conint(strict=True, ge=0)] = Field(None, description="The number of days past the billing period to allow for payment before it is considered due. This directly infers the due date for a payment. ")
    interest_product_id: Optional[StrictStr] = Field(None, description="An interest account product that the current account associates with. The account product must have its calculation_method set to COMPOUNDED_DAILY. ")
    minimum_payment: Optional[MinimumPaymentPartial] = None
    __properties = ["chargeoff_period", "credit_limit", "delinquency_period", "grace_period", "interest_product_id", "minimum_payment"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccountLineOfCreditAllOf:
        """Create an instance of AccountLineOfCreditAllOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of minimum_payment
        if self.minimum_payment:
            _dict['minimum_payment'] = self.minimum_payment.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AccountLineOfCreditAllOf:
        """Create an instance of AccountLineOfCreditAllOf from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AccountLineOfCreditAllOf.parse_obj(obj)

        _obj = AccountLineOfCreditAllOf.parse_obj({
            "chargeoff_period": obj.get("chargeoff_period") if obj.get("chargeoff_period") is not None else 90,
            "credit_limit": obj.get("credit_limit"),
            "delinquency_period": obj.get("delinquency_period") if obj.get("delinquency_period") is not None else 30,
            "grace_period": obj.get("grace_period"),
            "interest_product_id": obj.get("interest_product_id"),
            "minimum_payment": MinimumPaymentPartial.from_dict(obj.get("minimum_payment")) if obj.get("minimum_payment") is not None else None
        })
        return _obj

