# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conint, constr, validator
from synctera_client.models.account_access_status import AccountAccessStatus
from synctera_client.models.account_type import AccountType
from synctera_client.models.balance import Balance
from synctera_client.models.balance_ceiling import BalanceCeiling
from synctera_client.models.balance_floor import BalanceFloor
from synctera_client.models.billing_period import BillingPeriod
from synctera_client.models.customer_type import CustomerType
from synctera_client.models.minimum_payment import MinimumPayment
from synctera_client.models.security import Security
from synctera_client.models.spending_limits import SpendingLimits
from synctera_client.models.status import Status

class AccountGenericResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    access_status: Optional[AccountAccessStatus] = None
    access_status_last_updated_time: Optional[datetime] = Field(None, description="Timestamp of the last modification of the access_status. RFC3339 format.")
    account_number: Optional[constr(strict=True, max_length=50)] = Field(None, description="Account number")
    account_number_masked: Optional[constr(strict=True, max_length=50)] = Field(None, description="The response will contain the bank fintech ID (3 or 6 digits) plus the last 4 digits, with the digits in between replaced with * characters. Shadow mode account numbers will not be masked.")
    account_purpose: Optional[StrictStr] = Field(None, description="Purpose of the account")
    account_type: Optional[AccountType] = None
    application_id: Optional[StrictStr] = Field(None, description="The application ID for this account. ")
    balance_ceiling: Optional[BalanceCeiling] = None
    balance_floor: Optional[BalanceFloor] = None
    balances: Optional[List[Balance]] = Field(None, description="A list of balances for account based on different type")
    bank_routing: Optional[constr(strict=True, max_length=9)] = Field(None, description="Bank routing number")
    billing_period: Optional[BillingPeriod] = None
    business_ids: Optional[List[StrictStr]] = Field(None, description="A list of the business IDs of the account holders.")
    chargeoff_period: Optional[conint(strict=True, ge=0)] = Field(90, description="The number of days an account can stay delinquent before marking an account as charged-off. ")
    creation_time: Optional[datetime] = Field(None, description="Account creation timestamp in RFC3339 format")
    credit_limit: Optional[conint(strict=True, ge=0)] = Field(None, description="The credit limit for this line of credit account in cents. Minimum is 0. ")
    currency: Optional[constr(strict=True)] = Field(None, description="Account currency or account settlement currency. ISO 4217 alphabetic currency code. Default USD")
    customer_ids: Optional[List[StrictStr]] = Field(None, description="A list of the customer IDs of the account holders.")
    customer_type: Optional[CustomerType] = None
    delinquency_period: Optional[conint(strict=True, ge=0)] = Field(30, description="The number of days past the due date to wait for a minimum payment before marking an account as delinquent. ")
    exchange_rate_type: Optional[constr(strict=True, max_length=10)] = Field(None, description="Exchange rate type")
    fee_product_ids: Optional[List[StrictStr]] = Field(None, description="A list of fee account products that the current account associates with.")
    grace_period: Optional[conint(strict=True, ge=0)] = Field(None, description="The number of days past the billing period to allow for payment before it is considered due. This directly infers the due date for a payment. ")
    iban: Optional[constr(strict=True, max_length=34)] = Field(None, description="International bank account number")
    id: Optional[StrictStr] = Field(None, description="Account ID")
    interest_product_id: Optional[StrictStr] = Field(None, description="An interest account product that the current account associates with.")
    is_account_pool: Optional[StrictBool] = Field(None, description="Account is investment (variable balance) account or a multi-balance account pool. Default false")
    is_ach_enabled: Optional[StrictBool] = Field(None, description="A flag to indicate whether ACH transactions are enabled.")
    is_card_enabled: Optional[StrictBool] = Field(None, description="A flag to indicate whether card transactions are enabled.")
    is_p2p_enabled: Optional[StrictBool] = Field(None, description="A flag to indicate whether P2P transactions are enabled.")
    is_wire_enabled: Optional[StrictBool] = Field(None, description="A flag to indicate whether wire transactions are enabled.")
    last_updated_time: Optional[datetime] = Field(None, description="Timestamp of the last account modification in RFC3339 format")
    metadata: Optional[Dict[str, Any]] = Field(None, description="User provided account metadata")
    minimum_payment: Optional[MinimumPayment] = None
    nickname: Optional[StrictStr] = Field(None, description="User provided account nickname")
    overdraft_limit: Optional[conint(strict=True, ge=0)] = Field(None, description="Account's overdraft limit")
    security: Optional[Security] = None
    spend_control_ids: Optional[List[StrictStr]] = Field(None, description="List of spend control IDs to control spending for the account")
    spending_limits: Optional[SpendingLimits] = None
    status: Optional[Status] = None
    swift_code: Optional[constr(strict=True, max_length=11, min_length=8)] = Field(None, description="SWIFT code")
    tenant: Optional[StrictStr] = Field(None, description="The id of the tenant containing the resource. ")
    __properties = ["access_status", "access_status_last_updated_time", "account_number", "account_number_masked", "account_purpose", "account_type", "application_id", "balance_ceiling", "balance_floor", "balances", "bank_routing", "billing_period", "business_ids", "chargeoff_period", "creation_time", "credit_limit", "currency", "customer_ids", "customer_type", "delinquency_period", "exchange_rate_type", "fee_product_ids", "grace_period", "iban", "id", "interest_product_id", "is_account_pool", "is_ach_enabled", "is_card_enabled", "is_p2p_enabled", "is_wire_enabled", "last_updated_time", "metadata", "minimum_payment", "nickname", "overdraft_limit", "security", "spend_control_ids", "spending_limits", "status", "swift_code", "tenant"]

    @validator('currency')
    def currency_validate_regular_expression(cls, v):
        if not re.match(r"^[A-Z]{3}$", v):
            raise ValueError(r"must validate the regular expression /^[A-Z]{3}$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccountGenericResponse:
        """Create an instance of AccountGenericResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "access_status_last_updated_time",
                            "account_number",
                            "account_number_masked",
                            "balances",
                            "bank_routing",
                            "business_ids",
                            "creation_time",
                            "customer_ids",
                            "id",
                            "is_ach_enabled",
                            "is_card_enabled",
                            "is_p2p_enabled",
                            "is_wire_enabled",
                            "last_updated_time",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of balance_ceiling
        if self.balance_ceiling:
            _dict['balance_ceiling'] = self.balance_ceiling.to_dict()
        # override the default output from pydantic by calling `to_dict()` of balance_floor
        if self.balance_floor:
            _dict['balance_floor'] = self.balance_floor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in balances (list)
        _items = []
        if self.balances:
            for _item in self.balances:
                if _item:
                    _items.append(_item.to_dict())
            _dict['balances'] = _items
        # override the default output from pydantic by calling `to_dict()` of billing_period
        if self.billing_period:
            _dict['billing_period'] = self.billing_period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of minimum_payment
        if self.minimum_payment:
            _dict['minimum_payment'] = self.minimum_payment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of security
        if self.security:
            _dict['security'] = self.security.to_dict()
        # override the default output from pydantic by calling `to_dict()` of spending_limits
        if self.spending_limits:
            _dict['spending_limits'] = self.spending_limits.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AccountGenericResponse:
        """Create an instance of AccountGenericResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AccountGenericResponse.parse_obj(obj)

        _obj = AccountGenericResponse.parse_obj({
            "access_status": obj.get("access_status"),
            "access_status_last_updated_time": obj.get("access_status_last_updated_time"),
            "account_number": obj.get("account_number"),
            "account_number_masked": obj.get("account_number_masked"),
            "account_purpose": obj.get("account_purpose"),
            "account_type": obj.get("account_type"),
            "application_id": obj.get("application_id"),
            "balance_ceiling": BalanceCeiling.from_dict(obj.get("balance_ceiling")) if obj.get("balance_ceiling") is not None else None,
            "balance_floor": BalanceFloor.from_dict(obj.get("balance_floor")) if obj.get("balance_floor") is not None else None,
            "balances": [Balance.from_dict(_item) for _item in obj.get("balances")] if obj.get("balances") is not None else None,
            "bank_routing": obj.get("bank_routing"),
            "billing_period": BillingPeriod.from_dict(obj.get("billing_period")) if obj.get("billing_period") is not None else None,
            "business_ids": obj.get("business_ids"),
            "chargeoff_period": obj.get("chargeoff_period") if obj.get("chargeoff_period") is not None else 90,
            "creation_time": obj.get("creation_time"),
            "credit_limit": obj.get("credit_limit"),
            "currency": obj.get("currency"),
            "customer_ids": obj.get("customer_ids"),
            "customer_type": obj.get("customer_type"),
            "delinquency_period": obj.get("delinquency_period") if obj.get("delinquency_period") is not None else 30,
            "exchange_rate_type": obj.get("exchange_rate_type"),
            "fee_product_ids": obj.get("fee_product_ids"),
            "grace_period": obj.get("grace_period"),
            "iban": obj.get("iban"),
            "id": obj.get("id"),
            "interest_product_id": obj.get("interest_product_id"),
            "is_account_pool": obj.get("is_account_pool"),
            "is_ach_enabled": obj.get("is_ach_enabled"),
            "is_card_enabled": obj.get("is_card_enabled"),
            "is_p2p_enabled": obj.get("is_p2p_enabled"),
            "is_wire_enabled": obj.get("is_wire_enabled"),
            "last_updated_time": obj.get("last_updated_time"),
            "metadata": obj.get("metadata"),
            "minimum_payment": MinimumPayment.from_dict(obj.get("minimum_payment")) if obj.get("minimum_payment") is not None else None,
            "nickname": obj.get("nickname"),
            "overdraft_limit": obj.get("overdraft_limit"),
            "security": Security.from_dict(obj.get("security")) if obj.get("security") is not None else None,
            "spend_control_ids": obj.get("spend_control_ids"),
            "spending_limits": SpendingLimits.from_dict(obj.get("spending_limits")) if obj.get("spending_limits") is not None else None,
            "status": obj.get("status"),
            "swift_code": obj.get("swift_code"),
            "tenant": obj.get("tenant")
        })
        return _obj

