# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictStr

from typing import Optional

from synctera_client.models.watchlist_alert import WatchlistAlert
from synctera_client.models.watchlist_alert_list import WatchlistAlertList
from synctera_client.models.watchlist_subscription import WatchlistSubscription
from synctera_client.models.watchlist_subscription_list import WatchlistSubscriptionList
from synctera_client.models.watchlist_suppress import WatchlistSuppress

from synctera_client.api_client import ApiClient
from synctera_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class WatchlistDeprecatedApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_watchlist_alert(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], alert_id : Annotated[StrictStr, Field(..., description="Unique identifier for this watchlist alert.")], **kwargs) -> WatchlistAlert:  # noqa: E501
        """Retrieve watchlist monitoring alert  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_watchlist_alert(customer_id, alert_id, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param alert_id: Unique identifier for this watchlist alert. (required)
        :type alert_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WatchlistAlert
        """
        kwargs['_return_http_data_only'] = True
        return self.get_watchlist_alert_with_http_info(customer_id, alert_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_watchlist_alert_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], alert_id : Annotated[StrictStr, Field(..., description="Unique identifier for this watchlist alert.")], **kwargs):  # noqa: E501
        """Retrieve watchlist monitoring alert  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_watchlist_alert_with_http_info(customer_id, alert_id, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param alert_id: Unique identifier for this watchlist alert. (required)
        :type alert_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WatchlistAlert, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id',
            'alert_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_watchlist_alert" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']
        if _params['alert_id']:
            _path_params['alert_id'] = _params['alert_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "WatchlistAlert",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers/{customer_id}/watchlists/alerts/{alert_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_watchlist_subscription(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], subscription_id : Annotated[StrictStr, Field(..., description="Watchlist monitoring subscription ID")], **kwargs) -> WatchlistSubscription:  # noqa: E501
        """Retrieve watchlist monitoring subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_watchlist_subscription(customer_id, subscription_id, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param subscription_id: Watchlist monitoring subscription ID (required)
        :type subscription_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WatchlistSubscription
        """
        kwargs['_return_http_data_only'] = True
        return self.get_watchlist_subscription_with_http_info(customer_id, subscription_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_watchlist_subscription_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], subscription_id : Annotated[StrictStr, Field(..., description="Watchlist monitoring subscription ID")], **kwargs):  # noqa: E501
        """Retrieve watchlist monitoring subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_watchlist_subscription_with_http_info(customer_id, subscription_id, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param subscription_id: Watchlist monitoring subscription ID (required)
        :type subscription_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WatchlistSubscription, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id',
            'subscription_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_watchlist_subscription" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']
        if _params['subscription_id']:
            _path_params['subscription_id'] = _params['subscription_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "WatchlistSubscription",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers/{customer_id}/watchlists/subscriptions/{subscription_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_watchlist_alerts(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], **kwargs) -> WatchlistAlertList:  # noqa: E501
        """List watchlist monitoring alerts for a customer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_watchlist_alerts(customer_id, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WatchlistAlertList
        """
        kwargs['_return_http_data_only'] = True
        return self.list_watchlist_alerts_with_http_info(customer_id, **kwargs)  # noqa: E501

    @validate_arguments
    def list_watchlist_alerts_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], **kwargs):  # noqa: E501
        """List watchlist monitoring alerts for a customer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_watchlist_alerts_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WatchlistAlertList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_watchlist_alerts" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "WatchlistAlertList",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers/{customer_id}/watchlists/alerts', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_watchlist_subscriptions(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], **kwargs) -> WatchlistSubscriptionList:  # noqa: E501
        """List watchlist monitoring subscriptions for a customer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_watchlist_subscriptions(customer_id, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WatchlistSubscriptionList
        """
        kwargs['_return_http_data_only'] = True
        return self.list_watchlist_subscriptions_with_http_info(customer_id, **kwargs)  # noqa: E501

    @validate_arguments
    def list_watchlist_subscriptions_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], **kwargs):  # noqa: E501
        """List watchlist monitoring subscriptions for a customer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_watchlist_subscriptions_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WatchlistSubscriptionList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_watchlist_subscriptions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "WatchlistSubscriptionList",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers/{customer_id}/watchlists/subscriptions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def suppress_watchlist_entity_alert(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], watchlist_suppress : Annotated[WatchlistSuppress, Field(..., description="A watchlist suppression object")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs) -> None:  # noqa: E501
        """Suppress entity alert  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.suppress_watchlist_entity_alert(customer_id, watchlist_suppress, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param watchlist_suppress: A watchlist suppression object (required)
        :type watchlist_suppress: WatchlistSuppress
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.suppress_watchlist_entity_alert_with_http_info(customer_id, watchlist_suppress, idempotency_key, **kwargs)  # noqa: E501

    @validate_arguments
    def suppress_watchlist_entity_alert_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], watchlist_suppress : Annotated[WatchlistSuppress, Field(..., description="A watchlist suppression object")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs):  # noqa: E501
        """Suppress entity alert  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.suppress_watchlist_entity_alert_with_http_info(customer_id, watchlist_suppress, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param watchlist_suppress: A watchlist suppression object (required)
        :type watchlist_suppress: WatchlistSuppress
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'customer_id',
            'watchlist_suppress',
            'idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method suppress_watchlist_entity_alert" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['idempotency_key']:
            _header_params['Idempotency-Key'] = _params['idempotency_key']

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['watchlist_suppress']:
            _body_params = _params['watchlist_suppress']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/customers/{customer_id}/watchlists/suppressions', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_watchlist_alert(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], alert_id : Annotated[StrictStr, Field(..., description="Unique identifier for this watchlist alert.")], watchlist_alert : Annotated[WatchlistAlert, Field(..., description="A watchlist body")], **kwargs) -> None:  # noqa: E501
        """Update watchlist alert  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_watchlist_alert(customer_id, alert_id, watchlist_alert, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param alert_id: Unique identifier for this watchlist alert. (required)
        :type alert_id: str
        :param watchlist_alert: A watchlist body (required)
        :type watchlist_alert: WatchlistAlert
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.update_watchlist_alert_with_http_info(customer_id, alert_id, watchlist_alert, **kwargs)  # noqa: E501

    @validate_arguments
    def update_watchlist_alert_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], alert_id : Annotated[StrictStr, Field(..., description="Unique identifier for this watchlist alert.")], watchlist_alert : Annotated[WatchlistAlert, Field(..., description="A watchlist body")], **kwargs):  # noqa: E501
        """Update watchlist alert  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_watchlist_alert_with_http_info(customer_id, alert_id, watchlist_alert, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param alert_id: Unique identifier for this watchlist alert. (required)
        :type alert_id: str
        :param watchlist_alert: A watchlist body (required)
        :type watchlist_alert: WatchlistAlert
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'customer_id',
            'alert_id',
            'watchlist_alert'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_watchlist_alert" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']
        if _params['alert_id']:
            _path_params['alert_id'] = _params['alert_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['watchlist_alert']:
            _body_params = _params['watchlist_alert']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/customers/{customer_id}/watchlists/alerts/{alert_id}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_watchlist_subscription(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], subscription_id : Annotated[StrictStr, Field(..., description="Watchlist monitoring subscription ID")], watchlist_subscription : Annotated[WatchlistSubscription, Field(..., description="Watchlist monitoring subscription to be updated. The only field that matters is `status`; all other fields are ignored. ")], **kwargs) -> WatchlistSubscription:  # noqa: E501
        """Update watchlist monitoring subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_watchlist_subscription(customer_id, subscription_id, watchlist_subscription, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param subscription_id: Watchlist monitoring subscription ID (required)
        :type subscription_id: str
        :param watchlist_subscription: Watchlist monitoring subscription to be updated. The only field that matters is `status`; all other fields are ignored.  (required)
        :type watchlist_subscription: WatchlistSubscription
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WatchlistSubscription
        """
        kwargs['_return_http_data_only'] = True
        return self.update_watchlist_subscription_with_http_info(customer_id, subscription_id, watchlist_subscription, **kwargs)  # noqa: E501

    @validate_arguments
    def update_watchlist_subscription_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], subscription_id : Annotated[StrictStr, Field(..., description="Watchlist monitoring subscription ID")], watchlist_subscription : Annotated[WatchlistSubscription, Field(..., description="Watchlist monitoring subscription to be updated. The only field that matters is `status`; all other fields are ignored. ")], **kwargs):  # noqa: E501
        """Update watchlist monitoring subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_watchlist_subscription_with_http_info(customer_id, subscription_id, watchlist_subscription, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param subscription_id: Watchlist monitoring subscription ID (required)
        :type subscription_id: str
        :param watchlist_subscription: Watchlist monitoring subscription to be updated. The only field that matters is `status`; all other fields are ignored.  (required)
        :type watchlist_subscription: WatchlistSubscription
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WatchlistSubscription, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id',
            'subscription_id',
            'watchlist_subscription'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_watchlist_subscription" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']
        if _params['subscription_id']:
            _path_params['subscription_id'] = _params['subscription_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['watchlist_subscription']:
            _body_params = _params['watchlist_subscription']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "WatchlistSubscription",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers/{customer_id}/watchlists/subscriptions/{subscription_id}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def watchlist_subscribe(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], watchlist_subscription : Annotated[WatchlistSubscription, Field(..., description="A watchlist subscription")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs) -> WatchlistSubscription:  # noqa: E501
        """Subscribe a customer to watchlist monitoring  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.watchlist_subscribe(customer_id, watchlist_subscription, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param watchlist_subscription: A watchlist subscription (required)
        :type watchlist_subscription: WatchlistSubscription
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WatchlistSubscription
        """
        kwargs['_return_http_data_only'] = True
        return self.watchlist_subscribe_with_http_info(customer_id, watchlist_subscription, idempotency_key, **kwargs)  # noqa: E501

    @validate_arguments
    def watchlist_subscribe_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], watchlist_subscription : Annotated[WatchlistSubscription, Field(..., description="A watchlist subscription")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs):  # noqa: E501
        """Subscribe a customer to watchlist monitoring  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.watchlist_subscribe_with_http_info(customer_id, watchlist_subscription, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param watchlist_subscription: A watchlist subscription (required)
        :type watchlist_subscription: WatchlistSubscription
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WatchlistSubscription, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id',
            'watchlist_subscription',
            'idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watchlist_subscribe" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['idempotency_key']:
            _header_params['Idempotency-Key'] = _params['idempotency_key']

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['watchlist_subscription']:
            _body_params = _params['watchlist_subscription']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "WatchlistSubscription",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers/{customer_id}/watchlists/subscriptions', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
