# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import date

from pydantic import Field, StrictStr, conint

from typing import Optional

from synctera_client.models.pending_transaction import PendingTransaction
from synctera_client.models.pending_transactions import PendingTransactions
from synctera_client.models.posted_transaction import PostedTransaction
from synctera_client.models.posted_transactions import PostedTransactions

from synctera_client.api_client import ApiClient
from synctera_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class TransactionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_pending_transaction_by_id(self, id : Annotated[StrictStr, Field(..., description="Transaction ID")], **kwargs) -> PendingTransaction:  # noqa: E501
        """Get a pending transaction  # noqa: E501

        Get a pending transaction by its uuid   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_pending_transaction_by_id(id, async_req=True)
        >>> result = thread.get()

        :param id: Transaction ID (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PendingTransaction
        """
        kwargs['_return_http_data_only'] = True
        return self.get_pending_transaction_by_id_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_pending_transaction_by_id_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Transaction ID")], **kwargs):  # noqa: E501
        """Get a pending transaction  # noqa: E501

        Get a pending transaction by its uuid   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_pending_transaction_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Transaction ID (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PendingTransaction, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pending_transaction_by_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "PendingTransaction",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/transactions/pending/{id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_posted_transaction_by_id(self, id : Annotated[StrictStr, Field(..., description="Transaction ID")], **kwargs) -> PostedTransaction:  # noqa: E501
        """Get a posted transaction  # noqa: E501

        Get a posted transaction by its uuid   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_posted_transaction_by_id(id, async_req=True)
        >>> result = thread.get()

        :param id: Transaction ID (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PostedTransaction
        """
        kwargs['_return_http_data_only'] = True
        return self.get_posted_transaction_by_id_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_posted_transaction_by_id_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Transaction ID")], **kwargs):  # noqa: E501
        """Get a posted transaction  # noqa: E501

        Get a posted transaction by its uuid   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_posted_transaction_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Transaction ID (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PostedTransaction, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_posted_transaction_by_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "PostedTransaction",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/transactions/posted/{id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_pending_transactions(self, account_no : Annotated[Optional[StrictStr], Field(description="Account number")] = None, account_id : Annotated[Optional[StrictStr], Field(description="Account ID")] = None, from_date : Annotated[Optional[date], Field(description="Only display transactions with a posting date greater than from_date")] = None, to_date : Annotated[Optional[date], Field(description="Only display transactions with a posting date less than or equal to to_date")] = None, status : Annotated[Optional[StrictStr], Field(description="The status of the transaction")] = None, transaction_id : Annotated[Optional[StrictStr], Field(description="Only display holds linked to the provided transaction id")] = None, type : Annotated[Optional[StrictStr], Field(description="Only display transactions matching the given type")] = None, subtype : Annotated[Optional[StrictStr], Field(description="Only display transactions matching the given subtype")] = None, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, **kwargs) -> PendingTransactions:  # noqa: E501
        """List pending transactions  # noqa: E501

        Get paginated list of pending transactions matching the provided filters   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_pending_transactions(account_no, account_id, from_date, to_date, status, transaction_id, type, subtype, limit, page_token, async_req=True)
        >>> result = thread.get()

        :param account_no: Account number
        :type account_no: str
        :param account_id: Account ID
        :type account_id: str
        :param from_date: Only display transactions with a posting date greater than from_date
        :type from_date: date
        :param to_date: Only display transactions with a posting date less than or equal to to_date
        :type to_date: date
        :param status: The status of the transaction
        :type status: str
        :param transaction_id: Only display holds linked to the provided transaction id
        :type transaction_id: str
        :param type: Only display transactions matching the given type
        :type type: str
        :param subtype: Only display transactions matching the given subtype
        :type subtype: str
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PendingTransactions
        """
        kwargs['_return_http_data_only'] = True
        return self.list_pending_transactions_with_http_info(account_no, account_id, from_date, to_date, status, transaction_id, type, subtype, limit, page_token, **kwargs)  # noqa: E501

    @validate_arguments
    def list_pending_transactions_with_http_info(self, account_no : Annotated[Optional[StrictStr], Field(description="Account number")] = None, account_id : Annotated[Optional[StrictStr], Field(description="Account ID")] = None, from_date : Annotated[Optional[date], Field(description="Only display transactions with a posting date greater than from_date")] = None, to_date : Annotated[Optional[date], Field(description="Only display transactions with a posting date less than or equal to to_date")] = None, status : Annotated[Optional[StrictStr], Field(description="The status of the transaction")] = None, transaction_id : Annotated[Optional[StrictStr], Field(description="Only display holds linked to the provided transaction id")] = None, type : Annotated[Optional[StrictStr], Field(description="Only display transactions matching the given type")] = None, subtype : Annotated[Optional[StrictStr], Field(description="Only display transactions matching the given subtype")] = None, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, **kwargs):  # noqa: E501
        """List pending transactions  # noqa: E501

        Get paginated list of pending transactions matching the provided filters   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_pending_transactions_with_http_info(account_no, account_id, from_date, to_date, status, transaction_id, type, subtype, limit, page_token, async_req=True)
        >>> result = thread.get()

        :param account_no: Account number
        :type account_no: str
        :param account_id: Account ID
        :type account_id: str
        :param from_date: Only display transactions with a posting date greater than from_date
        :type from_date: date
        :param to_date: Only display transactions with a posting date less than or equal to to_date
        :type to_date: date
        :param status: The status of the transaction
        :type status: str
        :param transaction_id: Only display holds linked to the provided transaction id
        :type transaction_id: str
        :param type: Only display transactions matching the given type
        :type type: str
        :param subtype: Only display transactions matching the given subtype
        :type subtype: str
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PendingTransactions, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'account_no',
            'account_id',
            'from_date',
            'to_date',
            'status',
            'transaction_id',
            'type',
            'subtype',
            'limit',
            'page_token'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_pending_transactions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('account_no') is not None:  # noqa: E501
            _query_params.append(('account_no', _params['account_no']))
        if _params.get('account_id') is not None:  # noqa: E501
            _query_params.append(('account_id', _params['account_id']))
        if _params.get('from_date') is not None:  # noqa: E501
            _query_params.append(('from_date', _params['from_date']))
        if _params.get('to_date') is not None:  # noqa: E501
            _query_params.append(('to_date', _params['to_date']))
        if _params.get('status') is not None:  # noqa: E501
            _query_params.append(('status', _params['status']))
        if _params.get('transaction_id') is not None:  # noqa: E501
            _query_params.append(('transaction_id', _params['transaction_id']))
        if _params.get('type') is not None:  # noqa: E501
            _query_params.append(('type', _params['type']))
        if _params.get('subtype') is not None:  # noqa: E501
            _query_params.append(('subtype', _params['subtype']))
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('page_token') is not None:  # noqa: E501
            _query_params.append(('page_token', _params['page_token']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "PendingTransactions",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/transactions/pending', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_posted_transactions(self, account_no : Annotated[Optional[StrictStr], Field(description="Account number")] = None, account_id : Annotated[Optional[StrictStr], Field(description="Account ID")] = None, from_date : Annotated[Optional[date], Field(description="Only display transactions with a posting date greater than from_date")] = None, to_date : Annotated[Optional[date], Field(description="Only display transactions with a posting date less than or equal to to_date")] = None, type : Annotated[Optional[StrictStr], Field(description="Only display transactions matching the given type")] = None, subtype : Annotated[Optional[StrictStr], Field(description="Only display transactions matching the given subtype")] = None, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, **kwargs) -> PostedTransactions:  # noqa: E501
        """List posted transactions  # noqa: E501

        Get paginated list of posted transactions matching the provided filters   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_posted_transactions(account_no, account_id, from_date, to_date, type, subtype, limit, page_token, async_req=True)
        >>> result = thread.get()

        :param account_no: Account number
        :type account_no: str
        :param account_id: Account ID
        :type account_id: str
        :param from_date: Only display transactions with a posting date greater than from_date
        :type from_date: date
        :param to_date: Only display transactions with a posting date less than or equal to to_date
        :type to_date: date
        :param type: Only display transactions matching the given type
        :type type: str
        :param subtype: Only display transactions matching the given subtype
        :type subtype: str
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PostedTransactions
        """
        kwargs['_return_http_data_only'] = True
        return self.list_posted_transactions_with_http_info(account_no, account_id, from_date, to_date, type, subtype, limit, page_token, **kwargs)  # noqa: E501

    @validate_arguments
    def list_posted_transactions_with_http_info(self, account_no : Annotated[Optional[StrictStr], Field(description="Account number")] = None, account_id : Annotated[Optional[StrictStr], Field(description="Account ID")] = None, from_date : Annotated[Optional[date], Field(description="Only display transactions with a posting date greater than from_date")] = None, to_date : Annotated[Optional[date], Field(description="Only display transactions with a posting date less than or equal to to_date")] = None, type : Annotated[Optional[StrictStr], Field(description="Only display transactions matching the given type")] = None, subtype : Annotated[Optional[StrictStr], Field(description="Only display transactions matching the given subtype")] = None, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, **kwargs):  # noqa: E501
        """List posted transactions  # noqa: E501

        Get paginated list of posted transactions matching the provided filters   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_posted_transactions_with_http_info(account_no, account_id, from_date, to_date, type, subtype, limit, page_token, async_req=True)
        >>> result = thread.get()

        :param account_no: Account number
        :type account_no: str
        :param account_id: Account ID
        :type account_id: str
        :param from_date: Only display transactions with a posting date greater than from_date
        :type from_date: date
        :param to_date: Only display transactions with a posting date less than or equal to to_date
        :type to_date: date
        :param type: Only display transactions matching the given type
        :type type: str
        :param subtype: Only display transactions matching the given subtype
        :type subtype: str
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PostedTransactions, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'account_no',
            'account_id',
            'from_date',
            'to_date',
            'type',
            'subtype',
            'limit',
            'page_token'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_posted_transactions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('account_no') is not None:  # noqa: E501
            _query_params.append(('account_no', _params['account_no']))
        if _params.get('account_id') is not None:  # noqa: E501
            _query_params.append(('account_id', _params['account_id']))
        if _params.get('from_date') is not None:  # noqa: E501
            _query_params.append(('from_date', _params['from_date']))
        if _params.get('to_date') is not None:  # noqa: E501
            _query_params.append(('to_date', _params['to_date']))
        if _params.get('type') is not None:  # noqa: E501
            _query_params.append(('type', _params['type']))
        if _params.get('subtype') is not None:  # noqa: E501
            _query_params.append(('subtype', _params['subtype']))
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('page_token') is not None:  # noqa: E501
            _query_params.append(('page_token', _params['page_token']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "PostedTransactions",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/transactions/posted', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
