# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictStr, conint

from typing import List, Optional

from synctera_client.models.patch_payment_schedule import PatchPaymentSchedule
from synctera_client.models.payment_list import PaymentList
from synctera_client.models.payment_schedule import PaymentSchedule
from synctera_client.models.payment_schedule_list import PaymentScheduleList

from synctera_client.api_client import ApiClient
from synctera_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class PaymentSchedulesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_payment_schedule(self, payment_schedule : Annotated[PaymentSchedule, Field(..., description="payment schedule to create")], **kwargs) -> PaymentSchedule:  # noqa: E501
        """Create a payment schedule  # noqa: E501

        Create a payment schedule  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_payment_schedule(payment_schedule, async_req=True)
        >>> result = thread.get()

        :param payment_schedule: payment schedule to create (required)
        :type payment_schedule: PaymentSchedule
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PaymentSchedule
        """
        kwargs['_return_http_data_only'] = True
        return self.create_payment_schedule_with_http_info(payment_schedule, **kwargs)  # noqa: E501

    @validate_arguments
    def create_payment_schedule_with_http_info(self, payment_schedule : Annotated[PaymentSchedule, Field(..., description="payment schedule to create")], **kwargs):  # noqa: E501
        """Create a payment schedule  # noqa: E501

        Create a payment schedule  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_payment_schedule_with_http_info(payment_schedule, async_req=True)
        >>> result = thread.get()

        :param payment_schedule: payment schedule to create (required)
        :type payment_schedule: PaymentSchedule
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PaymentSchedule, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'payment_schedule'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_payment_schedule" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['payment_schedule']:
            _body_params = _params['payment_schedule']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "PaymentSchedule",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '409': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/payment_schedules', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_payment_schedules(self, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, id : Annotated[Optional[List[StrictStr]], Field(description="IDs. Multiple IDs can be provided as a comma-separated list.")] = None, account_id : Annotated[Optional[List[StrictStr]], Field(description="Originating account IDs. Multiple IDs can be provided as a comma-separated list.")] = None, customer_id : Annotated[Optional[List[StrictStr]], Field(description="The IDs of customers who created the payment schedules. Multiple IDs can be provided as a comma-separated list.")] = None, **kwargs) -> PaymentScheduleList:  # noqa: E501
        """List payment schedules  # noqa: E501

        Get paginated list of payment schedules  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_payment_schedules(limit, page_token, id, account_id, customer_id, async_req=True)
        >>> result = thread.get()

        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param id: IDs. Multiple IDs can be provided as a comma-separated list.
        :type id: List[str]
        :param account_id: Originating account IDs. Multiple IDs can be provided as a comma-separated list.
        :type account_id: List[str]
        :param customer_id: The IDs of customers who created the payment schedules. Multiple IDs can be provided as a comma-separated list.
        :type customer_id: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PaymentScheduleList
        """
        kwargs['_return_http_data_only'] = True
        return self.list_payment_schedules_with_http_info(limit, page_token, id, account_id, customer_id, **kwargs)  # noqa: E501

    @validate_arguments
    def list_payment_schedules_with_http_info(self, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, id : Annotated[Optional[List[StrictStr]], Field(description="IDs. Multiple IDs can be provided as a comma-separated list.")] = None, account_id : Annotated[Optional[List[StrictStr]], Field(description="Originating account IDs. Multiple IDs can be provided as a comma-separated list.")] = None, customer_id : Annotated[Optional[List[StrictStr]], Field(description="The IDs of customers who created the payment schedules. Multiple IDs can be provided as a comma-separated list.")] = None, **kwargs):  # noqa: E501
        """List payment schedules  # noqa: E501

        Get paginated list of payment schedules  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_payment_schedules_with_http_info(limit, page_token, id, account_id, customer_id, async_req=True)
        >>> result = thread.get()

        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param id: IDs. Multiple IDs can be provided as a comma-separated list.
        :type id: List[str]
        :param account_id: Originating account IDs. Multiple IDs can be provided as a comma-separated list.
        :type account_id: List[str]
        :param customer_id: The IDs of customers who created the payment schedules. Multiple IDs can be provided as a comma-separated list.
        :type customer_id: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PaymentScheduleList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'page_token',
            'id',
            'account_id',
            'customer_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_payment_schedules" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('page_token') is not None:  # noqa: E501
            _query_params.append(('page_token', _params['page_token']))
        if _params.get('id') is not None:  # noqa: E501
            _query_params.append(('id', _params['id']))
            _collection_formats['id'] = 'csv'
        if _params.get('account_id') is not None:  # noqa: E501
            _query_params.append(('account_id', _params['account_id']))
            _collection_formats['account_id'] = 'csv'
        if _params.get('customer_id') is not None:  # noqa: E501
            _query_params.append(('customer_id', _params['customer_id']))
            _collection_formats['customer_id'] = 'csv'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "PaymentScheduleList",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/payment_schedules', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_payments(self, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, id : Annotated[Optional[List[StrictStr]], Field(description="IDs. Multiple IDs can be provided as a comma-separated list.")] = None, schedule_id : Annotated[Optional[List[StrictStr]], Field(description="Payment schedule IDs. Multiple IDs can be provided as a comma-separated list.")] = None, account_id : Annotated[Optional[List[StrictStr]], Field(description="Originating account IDs. Multiple IDs can be provided as a comma-separated list.")] = None, customer_id : Annotated[Optional[List[StrictStr]], Field(description="The IDs of customers who created the payment schedules. Multiple IDs can be provided as a comma-separated list.")] = None, **kwargs) -> PaymentList:  # noqa: E501
        """List payments  # noqa: E501

        Get paginated list of payments  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_payments(limit, page_token, id, schedule_id, account_id, customer_id, async_req=True)
        >>> result = thread.get()

        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param id: IDs. Multiple IDs can be provided as a comma-separated list.
        :type id: List[str]
        :param schedule_id: Payment schedule IDs. Multiple IDs can be provided as a comma-separated list.
        :type schedule_id: List[str]
        :param account_id: Originating account IDs. Multiple IDs can be provided as a comma-separated list.
        :type account_id: List[str]
        :param customer_id: The IDs of customers who created the payment schedules. Multiple IDs can be provided as a comma-separated list.
        :type customer_id: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PaymentList
        """
        kwargs['_return_http_data_only'] = True
        return self.list_payments_with_http_info(limit, page_token, id, schedule_id, account_id, customer_id, **kwargs)  # noqa: E501

    @validate_arguments
    def list_payments_with_http_info(self, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, id : Annotated[Optional[List[StrictStr]], Field(description="IDs. Multiple IDs can be provided as a comma-separated list.")] = None, schedule_id : Annotated[Optional[List[StrictStr]], Field(description="Payment schedule IDs. Multiple IDs can be provided as a comma-separated list.")] = None, account_id : Annotated[Optional[List[StrictStr]], Field(description="Originating account IDs. Multiple IDs can be provided as a comma-separated list.")] = None, customer_id : Annotated[Optional[List[StrictStr]], Field(description="The IDs of customers who created the payment schedules. Multiple IDs can be provided as a comma-separated list.")] = None, **kwargs):  # noqa: E501
        """List payments  # noqa: E501

        Get paginated list of payments  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_payments_with_http_info(limit, page_token, id, schedule_id, account_id, customer_id, async_req=True)
        >>> result = thread.get()

        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param id: IDs. Multiple IDs can be provided as a comma-separated list.
        :type id: List[str]
        :param schedule_id: Payment schedule IDs. Multiple IDs can be provided as a comma-separated list.
        :type schedule_id: List[str]
        :param account_id: Originating account IDs. Multiple IDs can be provided as a comma-separated list.
        :type account_id: List[str]
        :param customer_id: The IDs of customers who created the payment schedules. Multiple IDs can be provided as a comma-separated list.
        :type customer_id: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PaymentList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'page_token',
            'id',
            'schedule_id',
            'account_id',
            'customer_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_payments" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('page_token') is not None:  # noqa: E501
            _query_params.append(('page_token', _params['page_token']))
        if _params.get('id') is not None:  # noqa: E501
            _query_params.append(('id', _params['id']))
            _collection_formats['id'] = 'csv'
        if _params.get('schedule_id') is not None:  # noqa: E501
            _query_params.append(('schedule_id', _params['schedule_id']))
            _collection_formats['schedule_id'] = 'csv'
        if _params.get('account_id') is not None:  # noqa: E501
            _query_params.append(('account_id', _params['account_id']))
            _collection_formats['account_id'] = 'csv'
        if _params.get('customer_id') is not None:  # noqa: E501
            _query_params.append(('customer_id', _params['customer_id']))
            _collection_formats['customer_id'] = 'csv'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "PaymentList",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/payment_schedules/payments', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def patch_payment_schedule(self, payment_schedule_id : Annotated[StrictStr, Field(..., description="Payment schedule ID")], patch_payment_schedule : Annotated[PatchPaymentSchedule, Field(..., description="payment schedule to update")], **kwargs) -> PaymentSchedule:  # noqa: E501
        """Update a payment schedule  # noqa: E501

        Update a payment schedule  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_payment_schedule(payment_schedule_id, patch_payment_schedule, async_req=True)
        >>> result = thread.get()

        :param payment_schedule_id: Payment schedule ID (required)
        :type payment_schedule_id: str
        :param patch_payment_schedule: payment schedule to update (required)
        :type patch_payment_schedule: PatchPaymentSchedule
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PaymentSchedule
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_payment_schedule_with_http_info(payment_schedule_id, patch_payment_schedule, **kwargs)  # noqa: E501

    @validate_arguments
    def patch_payment_schedule_with_http_info(self, payment_schedule_id : Annotated[StrictStr, Field(..., description="Payment schedule ID")], patch_payment_schedule : Annotated[PatchPaymentSchedule, Field(..., description="payment schedule to update")], **kwargs):  # noqa: E501
        """Update a payment schedule  # noqa: E501

        Update a payment schedule  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_payment_schedule_with_http_info(payment_schedule_id, patch_payment_schedule, async_req=True)
        >>> result = thread.get()

        :param payment_schedule_id: Payment schedule ID (required)
        :type payment_schedule_id: str
        :param patch_payment_schedule: payment schedule to update (required)
        :type patch_payment_schedule: PatchPaymentSchedule
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PaymentSchedule, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'payment_schedule_id',
            'patch_payment_schedule'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_payment_schedule" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['payment_schedule_id']:
            _path_params['payment_schedule_id'] = _params['payment_schedule_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['patch_payment_schedule']:
            _body_params = _params['patch_payment_schedule']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "PaymentSchedule",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '409': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/payment_schedules/{payment_schedule_id}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
