# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictStr, conint

from typing import Optional

from synctera_client.models.customer_verification import CustomerVerification
from synctera_client.models.customer_verification_result import CustomerVerificationResult
from synctera_client.models.customer_verification_result_list import CustomerVerificationResultList
from synctera_client.models.customer_verify_response import CustomerVerifyResponse

from synctera_client.api_client import ApiClient
from synctera_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class KYCVerificationDeprecatedApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_customer_verification_result(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], customer_verification_result : Annotated[CustomerVerificationResult, Field(..., description="Customer verification result to create.")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs) -> CustomerVerificationResult:  # noqa: E501
        """Create a customer verification result  # noqa: E501

        Create a verification result for a customer. This endpoint will be removed in API v1. Use `POST /v0/verifications` instead.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_customer_verification_result(customer_id, customer_verification_result, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param customer_verification_result: Customer verification result to create. (required)
        :type customer_verification_result: CustomerVerificationResult
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CustomerVerificationResult
        """
        kwargs['_return_http_data_only'] = True
        return self.create_customer_verification_result_with_http_info(customer_id, customer_verification_result, idempotency_key, **kwargs)  # noqa: E501

    @validate_arguments
    def create_customer_verification_result_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], customer_verification_result : Annotated[CustomerVerificationResult, Field(..., description="Customer verification result to create.")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs):  # noqa: E501
        """Create a customer verification result  # noqa: E501

        Create a verification result for a customer. This endpoint will be removed in API v1. Use `POST /v0/verifications` instead.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_customer_verification_result_with_http_info(customer_id, customer_verification_result, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param customer_verification_result: Customer verification result to create. (required)
        :type customer_verification_result: CustomerVerificationResult
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CustomerVerificationResult, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id',
            'customer_verification_result',
            'idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_customer_verification_result" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['idempotency_key']:
            _header_params['Idempotency-Key'] = _params['idempotency_key']

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['customer_verification_result']:
            _body_params = _params['customer_verification_result']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "CustomerVerificationResult",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers/{customer_id}/verifications', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_verification(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], verification_id : Annotated[StrictStr, Field(..., description="Unique identifier for the verification.")], **kwargs) -> CustomerVerificationResult:  # noqa: E501
        """Get verification result  # noqa: E501

        Get verification result by ID.  This endpoint will be removed in API v1. Use `GET /v0/verifications/{verification_id}` instead.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_verification(customer_id, verification_id, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param verification_id: Unique identifier for the verification. (required)
        :type verification_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CustomerVerificationResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_verification_with_http_info(customer_id, verification_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_verification_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], verification_id : Annotated[StrictStr, Field(..., description="Unique identifier for the verification.")], **kwargs):  # noqa: E501
        """Get verification result  # noqa: E501

        Get verification result by ID.  This endpoint will be removed in API v1. Use `GET /v0/verifications/{verification_id}` instead.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_verification_with_http_info(customer_id, verification_id, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param verification_id: Unique identifier for the verification. (required)
        :type verification_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CustomerVerificationResult, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id',
            'verification_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_verification" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']
        if _params['verification_id']:
            _path_params['verification_id'] = _params['verification_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "CustomerVerificationResult",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers/{customer_id}/verifications/{verification_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_verifications(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], include_history : Annotated[Optional[StrictBool], Field(description="If true, include old (inactive) records as well.")] = None, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, **kwargs) -> CustomerVerificationResultList:  # noqa: E501
        """List verification results  # noqa: E501

        List verification results.  This endpoint will be removed in API v1. Use `GET /v0/verifications?customer_id={customer_id}` instead.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_verifications(customer_id, include_history, limit, page_token, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param include_history: If true, include old (inactive) records as well.
        :type include_history: bool
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CustomerVerificationResultList
        """
        kwargs['_return_http_data_only'] = True
        return self.list_verifications_with_http_info(customer_id, include_history, limit, page_token, **kwargs)  # noqa: E501

    @validate_arguments
    def list_verifications_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], include_history : Annotated[Optional[StrictBool], Field(description="If true, include old (inactive) records as well.")] = None, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, **kwargs):  # noqa: E501
        """List verification results  # noqa: E501

        List verification results.  This endpoint will be removed in API v1. Use `GET /v0/verifications?customer_id={customer_id}` instead.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_verifications_with_http_info(customer_id, include_history, limit, page_token, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param include_history: If true, include old (inactive) records as well.
        :type include_history: bool
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CustomerVerificationResultList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id',
            'include_history',
            'limit',
            'page_token'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_verifications" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']

        # process the query parameters
        _query_params = []
        if _params.get('include_history') is not None:  # noqa: E501
            _query_params.append(('include_history', _params['include_history']))
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('page_token') is not None:  # noqa: E501
            _query_params.append(('page_token', _params['page_token']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "CustomerVerificationResultList",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers/{customer_id}/verifications', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def verify_customer(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], customer_verification : Annotated[CustomerVerification, Field(..., description="Customer verification request.")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs) -> CustomerVerifyResponse:  # noqa: E501
        """Verify a customer's identity  # noqa: E501

        Initiate identity verification for a customer and run the specified identity checks.  Verifying a personal customer requires that the following fields already be set: * `first_name` * `last_name` * `dob` * `email` * `phone_number` * `legal_address` * `ssn`  This endpoint will be removed in API v1. Use `POST /v0/verifications/verify` instead.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.verify_customer(customer_id, customer_verification, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param customer_verification: Customer verification request. (required)
        :type customer_verification: CustomerVerification
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CustomerVerifyResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.verify_customer_with_http_info(customer_id, customer_verification, idempotency_key, **kwargs)  # noqa: E501

    @validate_arguments
    def verify_customer_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], customer_verification : Annotated[CustomerVerification, Field(..., description="Customer verification request.")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs):  # noqa: E501
        """Verify a customer's identity  # noqa: E501

        Initiate identity verification for a customer and run the specified identity checks.  Verifying a personal customer requires that the following fields already be set: * `first_name` * `last_name` * `dob` * `email` * `phone_number` * `legal_address` * `ssn`  This endpoint will be removed in API v1. Use `POST /v0/verifications/verify` instead.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.verify_customer_with_http_info(customer_id, customer_verification, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param customer_verification: Customer verification request. (required)
        :type customer_verification: CustomerVerification
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CustomerVerifyResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id',
            'customer_verification',
            'idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method verify_customer" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['idempotency_key']:
            _header_params['Idempotency-Key'] = _params['idempotency_key']

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['customer_verification']:
            _body_params = _params['customer_verification']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "CustomerVerifyResponse",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers/{customer_id}/verify', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
