# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr, conint

from typing import Dict, List, Optional

from synctera_client.models.document import Document
from synctera_client.models.document_list import DocumentList
from synctera_client.models.document_type import DocumentType
from synctera_client.models.encryption import Encryption
from synctera_client.models.patch_document import PatchDocument
from synctera_client.models.related_resource_type import RelatedResourceType

from synctera_client.api_client import ApiClient
from synctera_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DocumentsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_document(self, file : Annotated[StrictStr, Field(..., description="The file contents")], description : Annotated[Optional[StrictStr], Field(description="A description of the attached document")] = None, encryption : Optional[Encryption] = None, is_restricted : Annotated[Optional[StrictBool], Field(description="whether this document should be restricted (special permissions will be used to access restricted documents)")] = None, metadata : Annotated[Optional[Dict[str, StrictStr]], Field(description="Optional field to store additional information about the resource. Intended to be used by the integrator to store non-sensitive data. ")] = None, name : Annotated[Optional[StrictStr], Field(description="A user-friendly name for the document")] = None, related_resource_id : Annotated[Optional[StrictStr], Field(description="The ID of the resource related to the document")] = None, related_resource_type : Optional[RelatedResourceType] = None, tenant : Annotated[Optional[StrictStr], Field(description="The id of the tenant containing the resource. ")] = None, type : Optional[DocumentType] = None, **kwargs) -> Document:  # noqa: E501
        """Create a document  # noqa: E501

        Docs   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_document(file, description, encryption, is_restricted, metadata, name, related_resource_id, related_resource_type, tenant, type, async_req=True)
        >>> result = thread.get()

        :param file: The file contents (required)
        :type file: str
        :param description: A description of the attached document
        :type description: str
        :param encryption:
        :type encryption: Encryption
        :param is_restricted: whether this document should be restricted (special permissions will be used to access restricted documents)
        :type is_restricted: bool
        :param metadata: Optional field to store additional information about the resource. Intended to be used by the integrator to store non-sensitive data. 
        :type metadata: object
        :param name: A user-friendly name for the document
        :type name: str
        :param related_resource_id: The ID of the resource related to the document
        :type related_resource_id: str
        :param related_resource_type:
        :type related_resource_type: RelatedResourceType
        :param tenant: The id of the tenant containing the resource. 
        :type tenant: str
        :param type:
        :type type: DocumentType
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Document
        """
        kwargs['_return_http_data_only'] = True
        return self.create_document_with_http_info(file, description, encryption, is_restricted, metadata, name, related_resource_id, related_resource_type, tenant, type, **kwargs)  # noqa: E501

    @validate_arguments
    def create_document_with_http_info(self, file : Annotated[StrictStr, Field(..., description="The file contents")], description : Annotated[Optional[StrictStr], Field(description="A description of the attached document")] = None, encryption : Optional[Encryption] = None, is_restricted : Annotated[Optional[StrictBool], Field(description="whether this document should be restricted (special permissions will be used to access restricted documents)")] = None, metadata : Annotated[Optional[Dict[str, StrictStr]], Field(description="Optional field to store additional information about the resource. Intended to be used by the integrator to store non-sensitive data. ")] = None, name : Annotated[Optional[StrictStr], Field(description="A user-friendly name for the document")] = None, related_resource_id : Annotated[Optional[StrictStr], Field(description="The ID of the resource related to the document")] = None, related_resource_type : Optional[RelatedResourceType] = None, tenant : Annotated[Optional[StrictStr], Field(description="The id of the tenant containing the resource. ")] = None, type : Optional[DocumentType] = None, **kwargs):  # noqa: E501
        """Create a document  # noqa: E501

        Docs   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_document_with_http_info(file, description, encryption, is_restricted, metadata, name, related_resource_id, related_resource_type, tenant, type, async_req=True)
        >>> result = thread.get()

        :param file: The file contents (required)
        :type file: str
        :param description: A description of the attached document
        :type description: str
        :param encryption:
        :type encryption: Encryption
        :param is_restricted: whether this document should be restricted (special permissions will be used to access restricted documents)
        :type is_restricted: bool
        :param metadata: Optional field to store additional information about the resource. Intended to be used by the integrator to store non-sensitive data. 
        :type metadata: object
        :param name: A user-friendly name for the document
        :type name: str
        :param related_resource_id: The ID of the resource related to the document
        :type related_resource_id: str
        :param related_resource_type:
        :type related_resource_type: RelatedResourceType
        :param tenant: The id of the tenant containing the resource. 
        :type tenant: str
        :param type:
        :type type: DocumentType
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Document, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'file',
            'description',
            'encryption',
            'is_restricted',
            'metadata',
            'name',
            'related_resource_id',
            'related_resource_type',
            'tenant',
            'type'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_document" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}
        if _params['description']:
            _form_params.append(('description', _params['description']))
        if _params['encryption']:
            _form_params.append(('encryption', _params['encryption']))
        if _params['file']:
            _files['file'] = _params['file']
        if _params['is_restricted']:
            _form_params.append(('is_restricted', _params['is_restricted']))
        if _params['metadata']:
            _form_params.append(('metadata', _params['metadata']))
        if _params['name']:
            _form_params.append(('name', _params['name']))
        if _params['related_resource_id']:
            _form_params.append(('related_resource_id', _params['related_resource_id']))
        if _params['related_resource_type']:
            _form_params.append(('related_resource_type', _params['related_resource_type']))
        if _params['tenant']:
            _form_params.append(('tenant', _params['tenant']))
        if _params['type']:
            _form_params.append(('type', _params['type']))

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "Document",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '409': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/documents', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_document_version(self, document_id : Annotated[StrictStr, Field(..., description="The unique identifier of the document.")], file : Annotated[StrictStr, Field(..., description="The file contents")], description : Annotated[Optional[StrictStr], Field(description="A description of the attached document")] = None, encryption : Optional[Encryption] = None, name : Annotated[Optional[StrictStr], Field(description="A user-friendly name for the document")] = None, type : Optional[DocumentType] = None, **kwargs) -> Document:  # noqa: E501
        """Create a new document version  # noqa: E501

        Docs   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_document_version(document_id, file, description, encryption, name, type, async_req=True)
        >>> result = thread.get()

        :param document_id: The unique identifier of the document. (required)
        :type document_id: str
        :param file: The file contents (required)
        :type file: str
        :param description: A description of the attached document
        :type description: str
        :param encryption:
        :type encryption: Encryption
        :param name: A user-friendly name for the document
        :type name: str
        :param type:
        :type type: DocumentType
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Document
        """
        kwargs['_return_http_data_only'] = True
        return self.create_document_version_with_http_info(document_id, file, description, encryption, name, type, **kwargs)  # noqa: E501

    @validate_arguments
    def create_document_version_with_http_info(self, document_id : Annotated[StrictStr, Field(..., description="The unique identifier of the document.")], file : Annotated[StrictStr, Field(..., description="The file contents")], description : Annotated[Optional[StrictStr], Field(description="A description of the attached document")] = None, encryption : Optional[Encryption] = None, name : Annotated[Optional[StrictStr], Field(description="A user-friendly name for the document")] = None, type : Optional[DocumentType] = None, **kwargs):  # noqa: E501
        """Create a new document version  # noqa: E501

        Docs   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_document_version_with_http_info(document_id, file, description, encryption, name, type, async_req=True)
        >>> result = thread.get()

        :param document_id: The unique identifier of the document. (required)
        :type document_id: str
        :param file: The file contents (required)
        :type file: str
        :param description: A description of the attached document
        :type description: str
        :param encryption:
        :type encryption: Encryption
        :param name: A user-friendly name for the document
        :type name: str
        :param type:
        :type type: DocumentType
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Document, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'document_id',
            'file',
            'description',
            'encryption',
            'name',
            'type'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_document_version" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['document_id']:
            _path_params['document_id'] = _params['document_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}
        if _params['description']:
            _form_params.append(('description', _params['description']))
        if _params['encryption']:
            _form_params.append(('encryption', _params['encryption']))
        if _params['file']:
            _files['file'] = _params['file']
        if _params['name']:
            _form_params.append(('name', _params['name']))
        if _params['type']:
            _form_params.append(('type', _params['type']))

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "Document",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '409': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/documents/{document_id}/versions', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_document(self, document_id : Annotated[StrictStr, Field(..., description="The unique identifier of the document.")], **kwargs) -> Document:  # noqa: E501
        """Get a document  # noqa: E501

        Returns the document attributes. Use /documents/{document_id}/contents to get the contents.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_document(document_id, async_req=True)
        >>> result = thread.get()

        :param document_id: The unique identifier of the document. (required)
        :type document_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Document
        """
        kwargs['_return_http_data_only'] = True
        return self.get_document_with_http_info(document_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_document_with_http_info(self, document_id : Annotated[StrictStr, Field(..., description="The unique identifier of the document.")], **kwargs):  # noqa: E501
        """Get a document  # noqa: E501

        Returns the document attributes. Use /documents/{document_id}/contents to get the contents.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_document_with_http_info(document_id, async_req=True)
        >>> result = thread.get()

        :param document_id: The unique identifier of the document. (required)
        :type document_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Document, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'document_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['document_id']:
            _path_params['document_id'] = _params['document_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "Document",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/documents/{document_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_document_contents(self, document_id : Annotated[StrictStr, Field(..., description="The unique identifier of the document.")], **kwargs) -> str:  # noqa: E501
        """Get contents of latest document version  # noqa: E501

        Returns the bytes of the requested document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_document_contents(document_id, async_req=True)
        >>> result = thread.get()

        :param document_id: The unique identifier of the document. (required)
        :type document_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_document_contents_with_http_info(document_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_document_contents_with_http_info(self, document_id : Annotated[StrictStr, Field(..., description="The unique identifier of the document.")], **kwargs):  # noqa: E501
        """Get contents of latest document version  # noqa: E501

        Returns the bytes of the requested document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_document_contents_with_http_info(document_id, async_req=True)
        >>> result = thread.get()

        :param document_id: The unique identifier of the document. (required)
        :type document_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'document_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_contents" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['document_id']:
            _path_params['document_id'] = _params['document_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/documents/{document_id}/contents', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_document_version(self, document_id : Annotated[StrictStr, Field(..., description="The unique identifier of the document.")], document_version : Annotated[StrictInt, Field(..., description="The document version.")], **kwargs) -> Document:  # noqa: E501
        """Get a document by version  # noqa: E501

        Returns the document (attributes). Use /documents/{document_id}/versions/{version}/contents to get the contents.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_document_version(document_id, document_version, async_req=True)
        >>> result = thread.get()

        :param document_id: The unique identifier of the document. (required)
        :type document_id: str
        :param document_version: The document version. (required)
        :type document_version: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Document
        """
        kwargs['_return_http_data_only'] = True
        return self.get_document_version_with_http_info(document_id, document_version, **kwargs)  # noqa: E501

    @validate_arguments
    def get_document_version_with_http_info(self, document_id : Annotated[StrictStr, Field(..., description="The unique identifier of the document.")], document_version : Annotated[StrictInt, Field(..., description="The document version.")], **kwargs):  # noqa: E501
        """Get a document by version  # noqa: E501

        Returns the document (attributes). Use /documents/{document_id}/versions/{version}/contents to get the contents.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_document_version_with_http_info(document_id, document_version, async_req=True)
        >>> result = thread.get()

        :param document_id: The unique identifier of the document. (required)
        :type document_id: str
        :param document_version: The document version. (required)
        :type document_version: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Document, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'document_id',
            'document_version'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_version" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['document_id']:
            _path_params['document_id'] = _params['document_id']
        if _params['document_version']:
            _path_params['document_version'] = _params['document_version']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "Document",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/documents/{document_id}/versions/{document_version}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_document_version_contents(self, document_id : Annotated[StrictStr, Field(..., description="The unique identifier of the document.")], document_version : Annotated[StrictInt, Field(..., description="The document version.")], **kwargs) -> str:  # noqa: E501
        """Get document contents by version  # noqa: E501

        Returns the bytes of the requested document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_document_version_contents(document_id, document_version, async_req=True)
        >>> result = thread.get()

        :param document_id: The unique identifier of the document. (required)
        :type document_id: str
        :param document_version: The document version. (required)
        :type document_version: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_document_version_contents_with_http_info(document_id, document_version, **kwargs)  # noqa: E501

    @validate_arguments
    def get_document_version_contents_with_http_info(self, document_id : Annotated[StrictStr, Field(..., description="The unique identifier of the document.")], document_version : Annotated[StrictInt, Field(..., description="The document version.")], **kwargs):  # noqa: E501
        """Get document contents by version  # noqa: E501

        Returns the bytes of the requested document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_document_version_contents_with_http_info(document_id, document_version, async_req=True)
        >>> result = thread.get()

        :param document_id: The unique identifier of the document. (required)
        :type document_id: str
        :param document_version: The document version. (required)
        :type document_version: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'document_id',
            'document_version'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_version_contents" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['document_id']:
            _path_params['document_id'] = _params['document_id']
        if _params['document_version']:
            _path_params['document_version'] = _params['document_version']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/documents/{document_id}/versions/{document_version}/contents', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_documents(self, id : Annotated[Optional[List[StrictStr]], Field(description="Unique resource identifier")] = None, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, related_resource_type : Annotated[Optional[RelatedResourceType], Field(description="Return documents that are related to resources of the specified type")] = None, related_resource_id : Annotated[Optional[StrictStr], Field(description="Return documents that are related to resources with the specified ID")] = None, encryption : Annotated[Optional[StrictStr], Field(description="Whether the file should be encrypted and access restricted, e.g. if the file contains PII")] = None, type : Annotated[Optional[DocumentType], Field(description="The type of documents")] = None, **kwargs) -> DocumentList:  # noqa: E501
        """List documents  # noqa: E501

        Returns a paginated list of documents (metadata only, not contents).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_documents(id, limit, page_token, related_resource_type, related_resource_id, encryption, type, async_req=True)
        >>> result = thread.get()

        :param id: Unique resource identifier
        :type id: List[str]
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param related_resource_type: Return documents that are related to resources of the specified type
        :type related_resource_type: RelatedResourceType
        :param related_resource_id: Return documents that are related to resources with the specified ID
        :type related_resource_id: str
        :param encryption: Whether the file should be encrypted and access restricted, e.g. if the file contains PII
        :type encryption: str
        :param type: The type of documents
        :type type: DocumentType
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DocumentList
        """
        kwargs['_return_http_data_only'] = True
        return self.list_documents_with_http_info(id, limit, page_token, related_resource_type, related_resource_id, encryption, type, **kwargs)  # noqa: E501

    @validate_arguments
    def list_documents_with_http_info(self, id : Annotated[Optional[List[StrictStr]], Field(description="Unique resource identifier")] = None, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, related_resource_type : Annotated[Optional[RelatedResourceType], Field(description="Return documents that are related to resources of the specified type")] = None, related_resource_id : Annotated[Optional[StrictStr], Field(description="Return documents that are related to resources with the specified ID")] = None, encryption : Annotated[Optional[StrictStr], Field(description="Whether the file should be encrypted and access restricted, e.g. if the file contains PII")] = None, type : Annotated[Optional[DocumentType], Field(description="The type of documents")] = None, **kwargs):  # noqa: E501
        """List documents  # noqa: E501

        Returns a paginated list of documents (metadata only, not contents).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_documents_with_http_info(id, limit, page_token, related_resource_type, related_resource_id, encryption, type, async_req=True)
        >>> result = thread.get()

        :param id: Unique resource identifier
        :type id: List[str]
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param related_resource_type: Return documents that are related to resources of the specified type
        :type related_resource_type: RelatedResourceType
        :param related_resource_id: Return documents that are related to resources with the specified ID
        :type related_resource_id: str
        :param encryption: Whether the file should be encrypted and access restricted, e.g. if the file contains PII
        :type encryption: str
        :param type: The type of documents
        :type type: DocumentType
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DocumentList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'limit',
            'page_token',
            'related_resource_type',
            'related_resource_id',
            'encryption',
            'type'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_documents" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('id') is not None:  # noqa: E501
            _query_params.append(('id', _params['id']))
            _collection_formats['id'] = 'csv'
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('page_token') is not None:  # noqa: E501
            _query_params.append(('page_token', _params['page_token']))
        if _params.get('related_resource_type') is not None:  # noqa: E501
            _query_params.append(('related_resource_type', _params['related_resource_type']))
        if _params.get('related_resource_id') is not None:  # noqa: E501
            _query_params.append(('related_resource_id', _params['related_resource_id']))
        if _params.get('encryption') is not None:  # noqa: E501
            _query_params.append(('encryption', _params['encryption']))
        if _params.get('type') is not None:  # noqa: E501
            _query_params.append(('type', _params['type']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "DocumentList",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/documents', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_document(self, document_id : Annotated[StrictStr, Field(..., description="The unique identifier of the document.")], patch_document : PatchDocument, **kwargs) -> Document:  # noqa: E501
        """Update a document  # noqa: E501

        Update attributes of the latest document version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_document(document_id, patch_document, async_req=True)
        >>> result = thread.get()

        :param document_id: The unique identifier of the document. (required)
        :type document_id: str
        :param patch_document: (required)
        :type patch_document: PatchDocument
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Document
        """
        kwargs['_return_http_data_only'] = True
        return self.update_document_with_http_info(document_id, patch_document, **kwargs)  # noqa: E501

    @validate_arguments
    def update_document_with_http_info(self, document_id : Annotated[StrictStr, Field(..., description="The unique identifier of the document.")], patch_document : PatchDocument, **kwargs):  # noqa: E501
        """Update a document  # noqa: E501

        Update attributes of the latest document version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_document_with_http_info(document_id, patch_document, async_req=True)
        >>> result = thread.get()

        :param document_id: The unique identifier of the document. (required)
        :type document_id: str
        :param patch_document: (required)
        :type patch_document: PatchDocument
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Document, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'document_id',
            'patch_document'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_document" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['document_id']:
            _path_params['document_id'] = _params['document_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['patch_document']:
            _body_params = _params['patch_document']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "Document",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/documents/{document_id}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
