# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictStr

from synctera_client.models.simulate_card_fulfillment import SimulateCardFulfillment

from synctera_client.api_client import ApiClient
from synctera_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class CardWebhookSimulationsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def simulate_card_fulfillment_event(self, card_id : StrictStr, simulate_card_fulfillment : Annotated[SimulateCardFulfillment, Field(..., description="Desired simulated fulfillment status change value")], **kwargs) -> SimulateCardFulfillment:  # noqa: E501
        """Simulate Card Fulfillment Event  # noqa: E501

        This endpoint is for testing environment only to trigger a simulated change in card fulfillment status event   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.simulate_card_fulfillment_event(card_id, simulate_card_fulfillment, async_req=True)
        >>> result = thread.get()

        :param card_id: (required)
        :type card_id: str
        :param simulate_card_fulfillment: Desired simulated fulfillment status change value (required)
        :type simulate_card_fulfillment: SimulateCardFulfillment
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SimulateCardFulfillment
        """
        kwargs['_return_http_data_only'] = True
        return self.simulate_card_fulfillment_event_with_http_info(card_id, simulate_card_fulfillment, **kwargs)  # noqa: E501

    @validate_arguments
    def simulate_card_fulfillment_event_with_http_info(self, card_id : StrictStr, simulate_card_fulfillment : Annotated[SimulateCardFulfillment, Field(..., description="Desired simulated fulfillment status change value")], **kwargs):  # noqa: E501
        """Simulate Card Fulfillment Event  # noqa: E501

        This endpoint is for testing environment only to trigger a simulated change in card fulfillment status event   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.simulate_card_fulfillment_event_with_http_info(card_id, simulate_card_fulfillment, async_req=True)
        >>> result = thread.get()

        :param card_id: (required)
        :type card_id: str
        :param simulate_card_fulfillment: Desired simulated fulfillment status change value (required)
        :type simulate_card_fulfillment: SimulateCardFulfillment
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SimulateCardFulfillment, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'card_id',
            'simulate_card_fulfillment'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulate_card_fulfillment_event" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['card_id']:
            _path_params['card_id'] = _params['card_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['simulate_card_fulfillment']:
            _body_params = _params['simulate_card_fulfillment']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "SimulateCardFulfillment",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/{card_id}/webhook_simulations/fulfillment', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
