# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictStr, conint, validator

from typing import List, Optional

from synctera_client.models.business import Business
from synctera_client.models.business_list import BusinessList
from synctera_client.models.patch_business import PatchBusiness

from synctera_client.api_client import ApiClient
from synctera_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class BusinessesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_business(self, business : Business, idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs) -> Business:  # noqa: E501
        """Create a business  # noqa: E501

        Create a business who may act as a customer or a related business. You can then verify the identity of this customer and associate them with other people and accounts.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_business(business, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param business: (required)
        :type business: Business
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Business
        """
        kwargs['_return_http_data_only'] = True
        return self.create_business_with_http_info(business, idempotency_key, **kwargs)  # noqa: E501

    @validate_arguments
    def create_business_with_http_info(self, business : Business, idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs):  # noqa: E501
        """Create a business  # noqa: E501

        Create a business who may act as a customer or a related business. You can then verify the identity of this customer and associate them with other people and accounts.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_business_with_http_info(business, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param business: (required)
        :type business: Business
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Business, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'business',
            'idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_business" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['idempotency_key']:
            _header_params['Idempotency-Key'] = _params['idempotency_key']

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['business']:
            _body_params = _params['business']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "Business",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '409': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/businesses', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_business(self, business_id : Annotated[StrictStr, Field(..., description="Business's unique identifier.")], **kwargs) -> Business:  # noqa: E501
        """Get business  # noqa: E501

        Get business by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_business(business_id, async_req=True)
        >>> result = thread.get()

        :param business_id: Business's unique identifier. (required)
        :type business_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Business
        """
        kwargs['_return_http_data_only'] = True
        return self.get_business_with_http_info(business_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_business_with_http_info(self, business_id : Annotated[StrictStr, Field(..., description="Business's unique identifier.")], **kwargs):  # noqa: E501
        """Get business  # noqa: E501

        Get business by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_business_with_http_info(business_id, async_req=True)
        >>> result = thread.get()

        :param business_id: Business's unique identifier. (required)
        :type business_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Business, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'business_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_business" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['business_id']:
            _path_params['business_id'] = _params['business_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "Business",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/businesses/{business_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_businesses(self, id : Annotated[Optional[List[StrictStr]], Field(description="Unique identifier for the business. Multiple IDs can be provided as a comma-separated list. ")] = None, entity_name : Optional[StrictStr] = None, phone_number : Optional[StrictStr] = None, status : Optional[StrictStr] = None, is_customer : Annotated[Optional[StrictBool], Field(description="If true, show only customers. If false, show non-customer parties.")] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="Specifies the sort order for the returned businesses. ")] = None, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, **kwargs) -> BusinessList:  # noqa: E501
        """List business  # noqa: E501

        Retrieves paginated list of businesses associated with the authorized requester.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_businesses(id, entity_name, phone_number, status, is_customer, sort_by, limit, page_token, async_req=True)
        >>> result = thread.get()

        :param id: Unique identifier for the business. Multiple IDs can be provided as a comma-separated list. 
        :type id: List[str]
        :param entity_name:
        :type entity_name: str
        :param phone_number:
        :type phone_number: str
        :param status:
        :type status: str
        :param is_customer: If true, show only customers. If false, show non-customer parties.
        :type is_customer: bool
        :param sort_by: Specifies the sort order for the returned businesses. 
        :type sort_by: List[str]
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: BusinessList
        """
        kwargs['_return_http_data_only'] = True
        return self.list_businesses_with_http_info(id, entity_name, phone_number, status, is_customer, sort_by, limit, page_token, **kwargs)  # noqa: E501

    @validate_arguments
    def list_businesses_with_http_info(self, id : Annotated[Optional[List[StrictStr]], Field(description="Unique identifier for the business. Multiple IDs can be provided as a comma-separated list. ")] = None, entity_name : Optional[StrictStr] = None, phone_number : Optional[StrictStr] = None, status : Optional[StrictStr] = None, is_customer : Annotated[Optional[StrictBool], Field(description="If true, show only customers. If false, show non-customer parties.")] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="Specifies the sort order for the returned businesses. ")] = None, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, **kwargs):  # noqa: E501
        """List business  # noqa: E501

        Retrieves paginated list of businesses associated with the authorized requester.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_businesses_with_http_info(id, entity_name, phone_number, status, is_customer, sort_by, limit, page_token, async_req=True)
        >>> result = thread.get()

        :param id: Unique identifier for the business. Multiple IDs can be provided as a comma-separated list. 
        :type id: List[str]
        :param entity_name:
        :type entity_name: str
        :param phone_number:
        :type phone_number: str
        :param status:
        :type status: str
        :param is_customer: If true, show only customers. If false, show non-customer parties.
        :type is_customer: bool
        :param sort_by: Specifies the sort order for the returned businesses. 
        :type sort_by: List[str]
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(BusinessList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'entity_name',
            'phone_number',
            'status',
            'is_customer',
            'sort_by',
            'limit',
            'page_token'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_businesses" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('id') is not None:  # noqa: E501
            _query_params.append(('id', _params['id']))
            _collection_formats['id'] = 'csv'
        if _params.get('entity_name') is not None:  # noqa: E501
            _query_params.append(('entity_name', _params['entity_name']))
        if _params.get('phone_number') is not None:  # noqa: E501
            _query_params.append(('phone_number', _params['phone_number']))
        if _params.get('status') is not None:  # noqa: E501
            _query_params.append(('status', _params['status']))
        if _params.get('is_customer') is not None:  # noqa: E501
            _query_params.append(('is_customer', _params['is_customer']))
        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sort_by', _params['sort_by']))
            _collection_formats['sort_by'] = 'csv'
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('page_token') is not None:  # noqa: E501
            _query_params.append(('page_token', _params['page_token']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "BusinessList",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/businesses', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_business(self, business_id : Annotated[StrictStr, Field(..., description="Business's unique identifier.")], patch_business : PatchBusiness, idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs) -> Business:  # noqa: E501
        """Patch business  # noqa: E501

        Update business by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_business(business_id, patch_business, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param business_id: Business's unique identifier. (required)
        :type business_id: str
        :param patch_business: (required)
        :type patch_business: PatchBusiness
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Business
        """
        kwargs['_return_http_data_only'] = True
        return self.update_business_with_http_info(business_id, patch_business, idempotency_key, **kwargs)  # noqa: E501

    @validate_arguments
    def update_business_with_http_info(self, business_id : Annotated[StrictStr, Field(..., description="Business's unique identifier.")], patch_business : PatchBusiness, idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs):  # noqa: E501
        """Patch business  # noqa: E501

        Update business by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_business_with_http_info(business_id, patch_business, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param business_id: Business's unique identifier. (required)
        :type business_id: str
        :param patch_business: (required)
        :type patch_business: PatchBusiness
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Business, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'business_id',
            'patch_business',
            'idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_business" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['business_id']:
            _path_params['business_id'] = _params['business_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['idempotency_key']:
            _header_params['Idempotency-Key'] = _params['idempotency_key']

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['patch_business']:
            _body_params = _params['patch_business']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "Business",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/businesses/{business_id}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
