# mypy-boto3-datapipeline

[![PyPI - mypy-boto3-datapipeline](https://img.shields.io/pypi/v/mypy-boto3-datapipeline.svg?color=blue)](https://pypi.org/project/mypy-boto3-datapipeline)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-datapipeline.svg?color=blue)](https://pypi.org/project/mypy-boto3-datapipeline)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.DataPipeline 1.16.53](https://boto3.amazonaws.com/v1/documentation/api/1.16.53/reference/services/datapipeline.html#DataPipeline) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.3.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-datapipeline](#mypy-boto3-datapipeline)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `DataPipeline` service.

```bash
python -m pip install boto3-stubs[datapipeline]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[datapipeline]` in your environment: `python -m pip install 'boto3-stubs[datapipeline]'`

Both type checking and auto-complete should work for `DataPipeline` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[datapipeline]` in your environment: `python -m pip install 'boto3-stubs[datapipeline]'`

Both type checking and auto-complete should work for `DataPipeline` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[datapipeline]` in your environment: `python -m pip install 'boto3-stubs[datapipeline]'`
- Run `mypy` as usual

Type checking should work for `DataPipeline` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[datapipeline]` in your environment: `python -m pip install 'boto3-stubs[datapipeline]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `DataPipeline` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`DataPipelineClient` provides annotations for `boto3.client("datapipeline")`.

```python
import boto3

from mypy_boto3_datapipeline import DataPipelineClient

client: DataPipelineClient = boto3.client("datapipeline")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: DataPipelineClient = session.client("datapipeline")
```

### Paginators annotations

`mypy_boto3_datapipeline.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_datapipeline import DataPipelineClient
from mypy_boto3_datapipeline.paginator import (
    DescribeObjectsPaginator,
    ListPipelinesPaginator,
    QueryObjectsPaginator,
)

client: DataPipelineClient = boto3.client("datapipeline")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_objects_paginator: DescribeObjectsPaginator = client.get_paginator("describe_objects")
list_pipelines_paginator: ListPipelinesPaginator = client.get_paginator("list_pipelines")
query_objects_paginator: QueryObjectsPaginator = client.get_paginator("query_objects")
```







### Typed dictionations

`mypy_boto3_datapipeline.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_datapipeline.type_defs import (
    CreatePipelineOutputTypeDef,
    DescribeObjectsOutputTypeDef,
    DescribePipelinesOutputTypeDef,
    EvaluateExpressionOutputTypeDef,
    FieldTypeDef,
    GetPipelineDefinitionOutputTypeDef,
    InstanceIdentityTypeDef,
    ListPipelinesOutputTypeDef,
    OperatorTypeDef,
    PaginatorConfigTypeDef,
    ParameterAttributeTypeDef,
    ParameterObjectTypeDef,
    ParameterValueTypeDef,
    PipelineDescriptionTypeDef,
    PipelineIdNameTypeDef,
    PipelineObjectTypeDef,
    PollForTaskOutputTypeDef,
    PutPipelineDefinitionOutputTypeDef,
    QueryObjectsOutputTypeDef,
    QueryTypeDef,
    ReportTaskProgressOutputTypeDef,
    ReportTaskRunnerHeartbeatOutputTypeDef,
    ResponseMetadata,
    SelectorTypeDef,
    TagTypeDef,
    TaskObjectTypeDef,
    ValidatePipelineDefinitionOutputTypeDef,
    ValidationErrorTypeDef,
    ValidationWarningTypeDef,
)

def get_structure() -> FieldTypeDef:
    return {
      ...
    }
```
