/**
 * The different types of data manipulation that Mito supports.
 */
export var StepType;
(function (StepType) {
    StepType["Initialize"] = "initialize";
    StepType["AddColumn"] = "add_column";
    StepType["DeleteColumn"] = "delete_column";
    StepType["RenameColumn"] = "rename_column";
    StepType["ReorderColumn"] = "reorder_column";
    StepType["FillNa"] = "fill_na";
    StepType["FilterColumn"] = "filter_column";
    StepType["SetColumnFormula"] = "set_column_formula";
    StepType["DataframeDelete"] = "dataframe_delete";
    StepType["DataframeDuplicate"] = "dataframe_duplicate";
    StepType["DataframeRename"] = "dataframe_rename";
    StepType["SimpleImport"] = "simple_import";
    StepType["Sort"] = "sort";
    StepType["Pivot"] = "pivot";
    StepType["Merge"] = "merge";
    StepType["Concat"] = "concat";
    StepType["DropDuplicates"] = "drop_duplicates";
    StepType["ChangeColumnDtype"] = "change_column_dtype";
    StepType["ChangeColumnFormat"] = "change_column_format";
    StepType["SetCellValue"] = "set_cell_value";
    StepType["BulkOldRename"] = "bulk_old_rename";
    StepType["ExcelImport"] = "excel_import";
    StepType["Graph"] = "graph";
    StepType["GraphDuplicate"] = "graph_duplicate";
    StepType["GraphDelete"] = "graph_delete";
    StepType["GraphRename"] = "graph_rename";
    StepType["DeleteRow"] = "delete_row";
    StepType["PromoteRowToHeader"] = "promote_row_to_header";
    StepType["SplitTextToColumns"] = "split_text_to_columns";
    StepType["Transpose"] = "transpose";
    StepType["Melt"] = "melt";
    // AUTOGENERATED LINE: STEPTYPE (DO NOT DELETE)
})(StepType || (StepType = {}));
export var UpdateType;
(function (UpdateType) {
    UpdateType["Undo"] = "undo";
    UpdateType["Redo"] = "redo";
    UpdateType["Clear"] = "clear";
    UpdateType["ArgsUpdate"] = "args_update";
    UpdateType["SaveAnalysisUpdate"] = "save_analysis_update";
    UpdateType["ReplayAnalysisUpdate"] = "replay_analysis_update";
    UpdateType["CheckoutStepByIdxUpdate"] = "checkout_step_by_idx_update";
    UpdateType["AppendUserFieldUpdate"] = "append_user_field_update";
    UpdateType["SetUserFieldUpdate"] = "set_user_field_update";
    UpdateType["UpdateFeedbackv2ObjObject"] = "update_feedback_v2_obj_update";
    UpdateType["GoPro"] = "go_pro";
    UpdateType["RenderCountUpdate"] = "render_count_update";
})(UpdateType || (UpdateType = {}));
/**
 * The original location of a specific dataframe.
 */
export var DFSource;
(function (DFSource) {
    DFSource["Passed"] = "passed";
    DFSource["Imported"] = "imported";
    DFSource["Pivoted"] = "pivoted";
    DFSource["Merged"] = "merged";
    DFSource["Duplicated"] = "duplicated";
    DFSource["Transposed"] = "transposed";
    DFSource["Melted"] = "melted";
})(DFSource || (DFSource = {}));
// NOTE: these aggregation functions need to be supported
// in mitosheet/steps/pivot.py as well
export var AggregationType;
(function (AggregationType) {
    AggregationType["COUNT"] = "count";
    AggregationType["COUNT_UNIQUE"] = "count unique";
    AggregationType["SUM"] = "sum";
    AggregationType["MEAN"] = "mean";
    AggregationType["MEDIAN"] = "median";
    AggregationType["STD"] = "std";
    AggregationType["MIN"] = "min";
    AggregationType["MAX"] = "max";
})(AggregationType || (AggregationType = {}));
/**
 * The type of data that is in this current Mito analysis.
 *
 * @remark this should be the same as the file in the Python code
 * which is in data_in_mito.py
 */
export var DataTypeInMito;
(function (DataTypeInMito) {
    DataTypeInMito["NONE"] = "none";
    DataTypeInMito["PROVIDED"] = "provided";
    DataTypeInMito["TUTORIAL"] = "tutorial";
    DataTypeInMito["PERSONAL"] = "personal";
})(DataTypeInMito || (DataTypeInMito = {}));
export var FormatType;
(function (FormatType) {
    FormatType["DEFAULT"] = "default";
    FormatType["PLAIN_TEXT"] = "plain text";
    FormatType["PERCENTAGE"] = "percentage";
    FormatType["CURRENCY"] = "currency";
    FormatType["ACCOUNTING"] = "accounting";
    FormatType["ROUND_DECIMALS"] = "round decimals";
    FormatType["K_M_B"] = "k_m_b";
    FormatType["SCIENTIFIC_NOTATION"] = "scientific notation";
})(FormatType || (FormatType = {}));
/*
    ActionEnum is used to identify a specific action.

    Listed in alphabetical order: first by non-spreadsheet functions,
    then by spreadsheet functions
*/
export var ActionEnum;
(function (ActionEnum) {
    ActionEnum["Add_Column"] = "add column";
    ActionEnum["Catch_Up"] = "catch up";
    ActionEnum["Clear"] = "clear";
    ActionEnum["Change_Dtype"] = "change dtype";
    ActionEnum["Column_Summary"] = "column summary";
    ActionEnum["Copy"] = "copy";
    ActionEnum["Delete_Column"] = "delete column";
    ActionEnum["Delete_Dataframe"] = "delete dataframe";
    ActionEnum["Delete_Graph"] = "delete graph";
    ActionEnum["Delete_Row"] = "delete row";
    ActionEnum["Drop_Duplicates"] = "drop duplicates";
    ActionEnum["Duplicate_Dataframe"] = "duplicate dataframe";
    ActionEnum["Duplicate_Graph"] = "duplicate graph";
    ActionEnum["Docs"] = "docs";
    ActionEnum["Export"] = "export";
    ActionEnum["Fill_Na"] = "fill na";
    ActionEnum["Filter"] = "filter";
    ActionEnum["Format"] = "format";
    ActionEnum["Fullscreen"] = "fullscreen";
    ActionEnum["Graph"] = "graph";
    ActionEnum["Help"] = "help";
    ActionEnum["Import"] = "import";
    ActionEnum["Merge"] = "merge";
    ActionEnum["Concat_Dataframes"] = "concat_dataframes";
    ActionEnum["Pivot"] = "pivot";
    ActionEnum["Promote_Row_To_Header"] = "promote row to header";
    ActionEnum["Redo"] = "redo";
    ActionEnum["Rename_Column"] = "rename column";
    ActionEnum["Rename_Dataframe"] = "rename dataframe";
    ActionEnum["Rename_Graph"] = "rename graph";
    ActionEnum["See_All_Functionality"] = "see all functionality";
    //Search = 'search',
    ActionEnum["Set_Cell_Value"] = "set cell value";
    ActionEnum["Set_Column_Formula"] = "set column formula";
    ActionEnum["Sort"] = "sort";
    ActionEnum["Split_Text_To_Column"] = "split text to column";
    ActionEnum["Steps"] = "steps";
    ActionEnum["Undo"] = "undo";
    ActionEnum["Unique_Values"] = "unique values";
    ActionEnum["Upgrade_To_Pro"] = "upgrade to pro";
    ActionEnum["Transpose"] = "transpose";
    ActionEnum["Melt"] = "melt";
    // AUTOGENERATED LINE: ACTIONENUM (DO NOT DELETE)
    /* Spreadsheet Formulas Section */
    ActionEnum["ABS"] = "abs";
    ActionEnum["AND"] = "and";
    ActionEnum["AVG"] = "avg";
    ActionEnum["BOOL"] = "bool";
    ActionEnum["CLEAN"] = "clean";
    ActionEnum["CONCAT"] = "concat";
    ActionEnum["CORR"] = "corr";
    ActionEnum["DATEVALUE"] = "datevalue";
    ActionEnum["DAY"] = "day";
    ActionEnum["ENDOFBUSINESSMONTH"] = "endofbusinessmonth";
    ActionEnum["ENDOFMONTH"] = "endofmonth";
    ActionEnum["EXP"] = "exp";
    ActionEnum["FILLNAN"] = "fillnan";
    ActionEnum["FIND"] = "find";
    ActionEnum["FLOAT"] = "float";
    ActionEnum["HOUR"] = "hour";
    ActionEnum["IF"] = "if";
    ActionEnum["INT"] = "int";
    ActionEnum["KURT"] = "kurt";
    ActionEnum["LEFT"] = "left";
    ActionEnum["LEN"] = "len";
    ActionEnum["LOWER"] = "lower";
    ActionEnum["MAX"] = "max";
    ActionEnum["MID"] = "mid";
    ActionEnum["MIN"] = "min";
    ActionEnum["MINUTE"] = "minute";
    ActionEnum["MONTH"] = "month";
    ActionEnum["MULTIPLY"] = "multiply";
    ActionEnum["OR"] = "or";
    ActionEnum["POWER"] = "power";
    ActionEnum["PROPER"] = "proper";
    ActionEnum["QUARTER"] = "quarter";
    ActionEnum["RIGHT"] = "right";
    ActionEnum["ROUND"] = "round";
    ActionEnum["SECOND"] = "second";
    ActionEnum["SKEW"] = "skew";
    ActionEnum["STARTOFBUSINESSMONTH"] = "startofbusinessmonth";
    ActionEnum["STARTOFMONTH"] = "startofmonth";
    ActionEnum["STRIPTIMETOMINUTES"] = "striptimetominutes";
    ActionEnum["STRIPTIMETOHOURS"] = "striptimetohours";
    ActionEnum["STRIPTIMETODAYS"] = "striptimetodays";
    ActionEnum["STRIPTIMETOMONTHS"] = "striptimetomonths";
    ActionEnum["STRIPTIMETOYEARS"] = "striptimetoyears";
    ActionEnum["SUBSTITUTE"] = "substitute";
    ActionEnum["SUM"] = "sum";
    ActionEnum["TEXT"] = "text";
    ActionEnum["TRIM"] = "trim";
    ActionEnum["TYPE"] = "type";
    ActionEnum["UPPER"] = "upper";
    ActionEnum["VALUE"] = "value";
    ActionEnum["VAR"] = "var";
    ActionEnum["WEEK"] = "week";
    ActionEnum["WEEEKDAY"] = "weekday";
    ActionEnum["YEAR"] = "year";
})(ActionEnum || (ActionEnum = {}));
export var GraphSidebarTab;
(function (GraphSidebarTab) {
    GraphSidebarTab["Setup"] = "setup";
    GraphSidebarTab["Style"] = "style";
    GraphSidebarTab["Export"] = "export";
})(GraphSidebarTab || (GraphSidebarTab = {}));
//# sourceMappingURL=types.js.map