// Copyright (c) Mito
import React from 'react';
import PivotInvalidSelectedColumnsError from './PivotInvalidSelectedColumnsError';
import DropdownButton from '../../elements/DropdownButton';
import Row from '../../spacing/Row';
import Col from '../../spacing/Col';
import DropdownItem from '../../elements/DropdownItem';
import { columnIDMapToDisplayHeadersMap, getDisplayColumnHeader } from '../../../utils/columnHeaders';
import SelectAndXIconCard from '../../elements/SelectAndXIconCard';
/*
  A custom component used in the pivot table which lets the
  user select column headers to add to the row or column keys
*/
const PivotTableKeySelection = (props) => {
    const pivotTableColumnIDsCards = props.selectedColumnIDs.map((columnID, keyIndex) => {
        return (React.createElement(SelectAndXIconCard, { key: keyIndex, value: columnID, titleMap: columnIDMapToDisplayHeadersMap(props.columnIDsMap), onChange: (columnID) => props.editKey(keyIndex, columnID), onDelete: () => props.removeKey(keyIndex), selectableValues: Object.keys(props.columnIDsMap) }));
    });
    return (React.createElement("div", null,
        React.createElement(Row, { justify: 'space-between', align: 'center' },
            React.createElement(Col, null,
                React.createElement("p", { className: 'text-header-3' }, props.sectionTitle)),
            React.createElement(Col, null,
                React.createElement(DropdownButton, { text: '+ Add', width: 'small', searchable: true }, Object.entries(props.columnIDsMap).map(([columnID, columnHeader]) => {
                    return (React.createElement(DropdownItem, { key: columnID, title: getDisplayColumnHeader(columnHeader), onClick: () => {
                            props.addKey(columnID);
                        } }));
                })))),
        props.sectionSubtext !== undefined &&
            React.createElement("p", { className: 'text-subtext-1' }, props.sectionSubtext),
        React.createElement(PivotInvalidSelectedColumnsError, { columnIDsMap: props.columnIDsMap, selectedColumnIDs: props.selectedColumnIDs, pivotSection: props.rowOrColumn, mitoAPI: props.mitoAPI }),
        pivotTableColumnIDsCards));
};
export default PivotTableKeySelection;
//# sourceMappingURL=PivotTableKeySelection.js.map