import React, { useState } from "react";
import DropdownItem from "../../elements/DropdownItem";
import Select from "../../elements/Select";
import Col from "../../spacing/Col";
import Row from "../../spacing/Row";
import { getDefaultMergeParams } from "./MergeTaskpane";
import '../../../../css/taskpanes/Merge/MergeSheetAndKeySelection.css';
const MergeSheetSection = (props) => {
    // We save the df names, so that the new sheet created through the merge cannot be selected
    const [dfNames] = useState(props.sheetDataArray.map(sheetData => sheetData.dfName));
    return (React.createElement("div", null,
        React.createElement(Row, { justify: "space-between" },
            React.createElement(Col, null,
                React.createElement("p", { className: 'text-header-3' }, "First Dataframe"),
                React.createElement(Select, { value: dfNames[props.params.sheet_index_one] || '', onChange: (dfName) => {
                        const newSheetIndex = dfNames.indexOf(dfName);
                        props.setParams(prevParams => {
                            const newParams = getDefaultMergeParams(props.sheetDataArray, newSheetIndex, prevParams.sheet_index_two, prevParams);
                            return newParams ? newParams : prevParams;
                        });
                    }, className: 'merge-sheet-selection-first-dataframe-select' }, dfNames.map(dfName => {
                    return (React.createElement(DropdownItem, { key: dfName, title: dfName }));
                }))),
            React.createElement(Col, { offsetRight: 2 },
                React.createElement("p", { className: 'text-header-3' }, "Second Dataframe"),
                React.createElement(Select, { value: dfNames[props.params.sheet_index_two] || '', onChange: (dfName) => {
                        const newSheetIndex = dfNames.indexOf(dfName);
                        props.setParams(prevParams => {
                            const newParams = getDefaultMergeParams(props.sheetDataArray, prevParams.sheet_index_one, newSheetIndex, prevParams);
                            return newParams ? newParams : prevParams;
                        });
                    }, width: 'medium' }, dfNames.map(dfName => {
                    return (React.createElement(DropdownItem, { key: dfName, title: dfName }));
                }))))));
};
export default MergeSheetSection;
//# sourceMappingURL=MergeSheetSelection.js.map