import React from "react";
import { StepType } from "../../../types";
import useLiveUpdatingParams from '../../../hooks/useLiveUpdatingParams';
import { getDtypeValue } from "../ControlPanel/FilterAndSortTab/DtypeCard";
import { getDisplayColumnHeader } from "../../../utils/columnHeaders";
import { addIfAbsent, removeIfPresent } from "../../../utils/arrays";
import Row from '../../spacing/Row';
import Col from '../../spacing/Col';
import MultiToggleItem from '../../elements/MultiToggleItem';
import MultiToggleBox from '../../elements/MultiToggleBox';
import DefaultTaskpane from "../DefaultTaskpane/DefaultTaskpane";
import DefaultTaskpaneBody from "../DefaultTaskpane/DefaultTaskpaneBody";
import DefaultTaskpaneHeader from "../DefaultTaskpane/DefaultTaskpaneHeader";
import DefaultEmptyTaskpane from "../DefaultTaskpane/DefaultEmptyTaskpane";
import Spacer from "../../spacing/Spacer";
import Tooltip from "../../elements/Tooltip";
import DataframeSelect from "../../elements/DataframeSelect";
const getDefaultParams = (sheetDataArray, sheetIndex) => {
    if (sheetDataArray.length === 0 || sheetDataArray[sheetIndex] === undefined) {
        return undefined;
    }
    return {
        sheet_index: sheetIndex,
        id_var_column_ids: [],
        value_var_column_ids: Object.keys(sheetDataArray[sheetIndex].columnDtypeMap || {}),
    };
};
/*
    This taskpane allows you to melt or unpivot a dataframe
*/
const MeltTaskpane = (props) => {
    const { params, setParams } = useLiveUpdatingParams(() => getDefaultParams(props.sheetDataArray, props.selectedSheetIndex), StepType.Melt, props.mitoAPI, props.analysisData, 50);
    if (params === undefined) {
        return React.createElement(DefaultEmptyTaskpane, { setUIState: props.setUIState });
    }
    const sheetData = props.sheetDataArray[params.sheet_index];
    const toggleIndexes = (param_name, indexes, newToggle) => {
        var _a;
        const columnIds = Object.keys((_a = props.sheetDataArray[params.sheet_index]) === null || _a === void 0 ? void 0 : _a.columnIDsMap) || [];
        const columnIdsToToggle = indexes.map(index => columnIds[index]);
        const newColumnIds = [...params[param_name]];
        columnIdsToToggle.forEach(columnID => {
            if (newToggle) {
                addIfAbsent(newColumnIds, columnID);
            }
            else {
                removeIfPresent(newColumnIds, columnID);
            }
        });
        setParams(prevParams => {
            return Object.assign(Object.assign({}, prevParams), { [param_name]: newColumnIds });
        });
    };
    return (React.createElement(DefaultTaskpane, null,
        React.createElement(DefaultTaskpaneHeader, { header: "Unpivot Dataframe", setUIState: props.setUIState }),
        React.createElement(DefaultTaskpaneBody, null,
            React.createElement(DataframeSelect, { title: 'Select a dataframe to unpivot.', sheetDataArray: props.sheetDataArray, sheetIndex: params.sheet_index, onChange: (newSheetIndex) => {
                    setParams(prevParams => {
                        const newParams = getDefaultParams(props.sheetDataArray, newSheetIndex);
                        if (newParams) {
                            return newParams;
                        }
                        return Object.assign(Object.assign({}, prevParams), { sheet_index: newSheetIndex });
                    });
                } }),
            React.createElement(Row, { justify: 'start', align: 'center', title: 'Column to use as identifier variables.' },
                React.createElement(Col, null,
                    React.createElement("p", { className: 'text-header-3' }, "ID Variables")),
                React.createElement(Col, { offset: .5 },
                    React.createElement(Tooltip, { title: "Column to use as identifier variables. These columns will be present in the unpivoted dataframe." }))),
            React.createElement(MultiToggleBox, { searchable: true, toggleAllIndexes: (indexesToToggle, newValue) => {
                    toggleIndexes('id_var_column_ids', indexesToToggle, newValue);
                }, height: 'medium' }, Object.entries((sheetData === null || sheetData === void 0 ? void 0 : sheetData.columnDtypeMap) || {}).map(([columnID, columnDtype], index) => {
                const columnIDsMap = (sheetData === null || sheetData === void 0 ? void 0 : sheetData.columnIDsMap) || {};
                const columnHeader = columnIDsMap[columnID];
                const toggle = params.id_var_column_ids.includes(columnID);
                return (React.createElement(MultiToggleItem, { key: index, index: index, title: getDisplayColumnHeader(columnHeader), rightText: getDtypeValue(columnDtype), toggled: toggle, onToggle: () => {
                        toggleIndexes('id_var_column_ids', [index], !toggle);
                    } }));
            })),
            React.createElement(Spacer, { px: 10 }),
            React.createElement(Row, { justify: 'start', align: 'center', title: 'Columns to unpivot.' },
                React.createElement(Col, null,
                    React.createElement("p", { className: 'text-header-3' }, "Values")),
                React.createElement(Col, { offset: .5 },
                    React.createElement(Tooltip, { title: "Column to unpivot. Each column header will go in the variables column, and the column values will go in the values column." }))),
            React.createElement(MultiToggleBox, { searchable: true, toggleAllIndexes: (indexesToToggle, newValue) => {
                    toggleIndexes('value_var_column_ids', indexesToToggle, newValue);
                }, height: 'medium' }, Object.entries((sheetData === null || sheetData === void 0 ? void 0 : sheetData.columnDtypeMap) || {}).map(([columnID, columnDtype], index) => {
                const columnIDsMap = (sheetData === null || sheetData === void 0 ? void 0 : sheetData.columnIDsMap) || {};
                const columnHeader = columnIDsMap[columnID];
                // We turn off and disable the toggle in the case it is included in the id variables, 
                // as pandas automatically filters the id variables out from the value variables
                const toggle = params.id_var_column_ids.includes(columnID) ? false : params.value_var_column_ids.includes(columnID);
                const disabled = params.id_var_column_ids.includes(columnID);
                return (React.createElement(MultiToggleItem, { key: index, index: index, title: getDisplayColumnHeader(columnHeader), rightText: getDtypeValue(columnDtype), toggled: toggle, onToggle: () => {
                        toggleIndexes('value_var_column_ids', [index], !toggle);
                    }, disabled: disabled }));
            })))));
};
export default MeltTaskpane;
//# sourceMappingURL=MeltTaskpane.js.map