// Copyright (c) Mito
import React from 'react';
import "../../../../css/taskpanes/DefaultTaskpane.css";
import XIcon from '../../icons/XIcon';
import { TaskpaneType } from '../taskpanes';
import BackArrowIcon from '../../icons/BackArrowIcon';
import Row from '../../spacing/Row';
import Col from '../../spacing/Col';
/*
    A container for the main header of a taskpane, with some helpful props to
    make common header actions easy. Usually wrapped in a DefaultTaskpane.
*/
const DefaultTaskpane = (props) => {
    return (React.createElement("div", { className: 'default-taskpane-header-div' },
        React.createElement(Row, { suppressTopBottomMargin: true },
            React.createElement(Col, { span: 23 },
                typeof props.header !== 'string' &&
                    props.header,
                typeof props.header === 'string' &&
                    React.createElement("div", { className: 'default-taskpane-header-and-back-button' },
                        props.backCallback !== undefined &&
                            React.createElement("div", { onClick: props.backCallback, className: 'mt-5px mr-10px' },
                                React.createElement(BackArrowIcon, null)),
                        React.createElement("p", { className: 'text-header-2 text-overflow-hide' }, props.header))),
            React.createElement(Col, { span: 1 }, !props.notCloseable &&
                React.createElement("div", { className: 'default-taskpane-header-exit-button-div', onClick: () => {
                        // Call the on close callback, if it exists
                        if (props.callbackOnClose) {
                            props.callbackOnClose();
                        }
                        props.setUIState((prevUIState) => {
                            return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: { type: TaskpaneType.NONE } });
                        });
                    } },
                    React.createElement(XIcon, null))))));
};
export default DefaultTaskpane;
//# sourceMappingURL=DefaultTaskpaneHeader.js.map