// Copyright (c) Saga Inc.
import React, { useEffect } from 'react';
import Dropdown from '../elements/Dropdown';
import DropdownItem from '../elements/DropdownItem';
import { getSelectedRowLabelsWithEntireSelectedRow } from './selectionUtils';
/*
    Displays a set of actions one can perform on a row
*/
export default function IndexHeaderDropdown(props) {
    // Log opening this dropdown
    useEffect(() => {
        if (props.display) {
            void props.mitoAPI.log('opened_index_header_dropdown');
        }
    }, [props.display]);
    return (React.createElement(Dropdown, { display: props.display, closeDropdown: () => props.setOpenIndexHeaderDropdown(undefined), width: 'medium' },
        React.createElement(DropdownItem, { title: 'Delete Rows', onClick: () => {
                void props.mitoAPI.editDeleteRow(props.sheetIndex, getSelectedRowLabelsWithEntireSelectedRow(props.selections, props.sheetData));
            } }),
        React.createElement(DropdownItem, { title: 'Promote Row to Header', onClick: () => {
                void props.mitoAPI.editPromoteRowToHeader(props.sheetIndex, props.index);
            } })));
}
//# sourceMappingURL=IndexHeaderDropdown.js.map