# Generated by Django 2.2.12 on 2020-05-29 13:59

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import hashid_field.field


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Transaction',
            fields=[
                ('order_number', hashid_field.field.HashidAutoField(alphabet='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890', min_length=7, primary_key=True, serialize=False)),
                ('amount', models.DecimalField(decimal_places=2, max_digits=64)),
                ('authority', models.CharField(blank=True, max_length=100, null=True)),
                ('ref_id', models.IntegerField(blank=True, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('verified_at', models.DateTimeField(blank=True, null=True)),
                ('status', models.CharField(choices=[('PENDING', 'Transaction has just started'), ('FAILED', 'Transaction has failed'), ('SUCCESS', 'Transaction has successfully done')], default='PENDING', max_length=100)),
                ('failure_reason', models.CharField(blank=True, max_length=100, null=True)),
                ('is_test', models.BooleanField(default=False)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
