# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dvbctrl']

package_data = \
{'': ['*']}

install_requires = \
['psutil>=5.9.1,<6.0.0']

setup_kwargs = {
    'name': 'dvbctrl',
    'version': '0.3.9',
    'description': 'Controls a local dvbstreamer',
    'long_description': '# dvbctrl\n\nModule to control a local [dvbstreamer](http://sourceforge.net/projects/dvbstreamer/).  On Arch you can install dvbstreamer from\nthe [AUR](https://aur.archlinux.org/packages/dvbstreamer).\n\n## starting\n\n```python\nfrom dvbctrl.dvbstreamer import DVBStreamer\n\nadapter = 0\ndvbs = DVBStreamer(adapter)\nrunning = dvbs.start()\nif not running:\n    raise Exception(f"Failed to start dvbstreamer on adapter {adapter}")\n```\n\n## stopping\n\n```python\nfrom dvbctrl.dvbstreamer import DVBStreamer\n\nadapter = 0\ndvbs = DVBStreamer(adapter)\n\n...\n\nif dvbs.isRunning():\n    dvbs.stop()\n```\n\n## commands\n\n```python\nfrom dvbctrl.commands import DVBCommand\n\nkwargs = {\n    "adapter": 0,\n    "host": "127.0.0.1"\n    "pass": "dvbctrl"\n    "user": "dvbctrl"\n}\ndvbc = DVBCommand(**kwargs)\n\n# services (channels)\nchans = dvbc.lsservices()\n```\n\n## recorder\n\nA simple interface to dvbctrl to easily record to files from channels.  Utilises the primary service filter only.\n\n```\nfrom dvbctrl.recorder import Recorder\n\n# initialise the recorder\nr = Recorder("BBC TWO", "/tmp/bbc_two.ts", adapter=0)\n\n# start the recorder, this checks that the file is growing\nr.start()\n\n...\n\n# stop the recording\nr.stop()\n```\n\nYou can periodically check that the recording file is still growing by using the check function, passing in the last file size.\nThis returns a tuple containing a True/False flag and the current size.  If the flag is False (i.e. the file isn\'t growing or is\nnot there) then the lastsize argument is returned.\n\n```\nisok, currentsize = r.check(12345)\n```\n## dvbctrl recorder commands\n\n* `tuneToChannel()` Tunes the dvbstreamer to a channel will wait up to 5 seconds for dvbstreamer to stabilise. Returns True if\n  tuned or False otherwise\n* `isTuned()` returns True if tuned, False otherwise\n* `waitTuned()` waits for up to 5 seconds for the streamer to tune returns True if tuned successfully, False otherwise\n\n## dvbctrl commands\n\n* `select` Select a new service to stream.\n* `setmrl` Set the MRL of the primary service filter.\n* `getmrl` Get the primary service filter MRL.\n* `addsf` Add a service filter.\n* `rmsf` Remove a service filter.\n* `lssfs` List all service filters.\n* `setsf` Set the service to be filtered by a service filter.\n* `getsf` Get the service to stream to a secondary service output.\n* `setsfmrl` Set the service filter\'s MRL.\n* `getsfmrl` Get the service filter\'s MRL.\n* `setsfavsonly` Enable/disable streaming of Audio/Video/Subtitles only.\n* `getsfavsonly` Get whether Audio/Video/Subtitles only streaming is enabled.\n* `lsservices` List all services or for a specific multiplex.\n* `lsmuxes` List multiplexes.\n* `lspids` List the PIDs for a specified service.\n* `current` Print out the service currently being streamed.\n* `serviceinfo` Display information about a service.\n* `muxinfo` Display information about a mux.\n* `stats` Display the stats for the PAT,PMT and service PID filters.\n* `festatus` Displays the status of the tuner.\n* `scan` Scan the specified multiplex(es) for services.\n* `cancelscan` Cancel the any scan that is in progress.\n* `lslcn` List the logical channel numbers to services.\n* `findlcn` Find the service for a logical channel number.\n* `selectlcn` Select the service from a logical channel number.\n* `lsmfs` List current filters.\n\n### dvbctrl commands not yet implemented\n\n* `feparams` Get current frontend parameters. (NOT IMPLEMENTED)\n* `lsprops` List available properties. (NOT IMPLEMENTED)\n* `getprop` Get the value of a property. (NOT IMPLEMENTED)\n* `setprop` Set the value of a property. (NOT IMPLEMENTED)\n* `propinfo` Display information about a property. (NOT IMPLEMENTED)\n* `dumptsr` Dump information from the TSReader (NOT IMPLEMENTED)\n* `lslnbs` List known LNBs (NOT IMPLEMENTED)\n* `epgdata` Register to receive EPG data in XML format. (NOT IMPLEMENTED)\n* `date` Display the last date/time received. (NOT IMPLEMENTED)\n* `enabledsmcc` Enable DSM-CC data download for the specified service filter. (NOT IMPLEMENTED)\n* `disabledsmcc` Disable DSM-CC data download for the specified service filter. (NOT IMPLEMENTED)\n* `dsmccinfo` Display DSM-CC info for the specified service filter. (NOT IMPLEMENTED)\n* `epgcaprestart` Starts or restarts the capturing of EPG content. (NOT IMPLEMENTED)\n* `epgcapstart` Starts the capturing of EPG content. (NOT IMPLEMENTED)\n* `epgcapstop` Stops the capturing of EPG content. (NOT IMPLEMENTED)\n* `now` Display the current program on the specified service. (NOT IMPLEMENTED)\n* `next` Display the next program on the specified service. (NOT IMPLEMENTED)\n* `addlistener` Add a destination to send event notification to. (NOT IMPLEMENTED)\n* `rmlistener` Remove a destination to send event notification to. (NOT IMPLEMENTED)\n* `lslisteners` List all registered event listener (NOT IMPLEMENTED)\n* `addlistenevent` Add an internal event to monitor. (NOT IMPLEMENTED)\n* `rmlistenevent` Remove an internal event to monitor (NOT IMPLEMENTED)\n* `lslistenevents` List all registered event listener (NOT IMPLEMENTED)\n* `addmf` Add a new destination for manually filtered PIDs. (NOT IMPLEMENTED)\n* `rmmf` Remove a destination for manually filtered PIDs. (NOT IMPLEMENTED)\n* `setmfmrl` Set the filter\'s MRL. (NOT IMPLEMENTED)\n* `addmfpid` Adds a PID to a filter. (NOT IMPLEMENTED)\n* `rmmfpid` Removes a PID from a filter. (NOT IMPLEMENTED)\n* `lsmfpids` List PIDs for filter. (NOT IMPLEMENTED)\n* `addoutput` Add a new output. (NOT IMPLEMENTED)\n* `rmoutput` Remove an output. (NOT IMPLEMENTED)\n* `enablesicap` Enable the capture of PSI/SI data. (NOT IMPLEMENTED)\n* `disablesicap` Disable the capture of PSI/SI data. (NOT IMPLEMENTED)\n* `lsplugins` List loaded plugins. (NOT IMPLEMENTED)\n* `plugininfo` Display the information about a plugin. (NOT IMPLEMENTED)\n* `who` Display current control connections. (NOT IMPLEMENTED)\n* `auth` Login to control dvbstreamer. (NOT IMPLEMENTED)\n* `logout` Close the current control connection. (NOT IMPLEMENTED)\n* `quit` Exit the program. (NOT IMPLEMENTED)\n* `help` Display the list of commands or help on a specific command. (NOT IMPLEMENTED)\n',
    'author': 'ccdale',
    'author_email': 'chris.charles.allison+dvbctrl@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/ccdale/dvbctrl',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
